/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.util;

import com.zoho.api.logger.SDKLogger;
import com.zoho.crm.api.Initializer;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.Converter;
import com.zoho.crm.api.util.Utility;
import java.io.File;
import java.io.FileWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.json.JSONObject;

public class ModuleFieldsHandler {
    private static final Logger LOGGER = Logger.getLogger(SDKLogger.class.getName());

    private static String getDirectory() {
        return Initializer.getInitializer().getResourcePath() + File.separator + "resources";
    }

    public static synchronized void deleteFieldsFile() throws SDKException {
        try {
            Converter converterInstance = new Converter(){

                @Override
                public Object getWrappedResponse(Object response, String pack) throws Exception {
                    return null;
                }

                @Override
                public Object getResponse(Object response, String pack) throws Exception {
                    return null;
                }

                @Override
                public Object formRequest(Object requestInstance, String pack, Integer instanceNumber, JSONObject memberDetail) throws Exception {
                    return null;
                }

                @Override
                public void appendToRequest(HttpEntityEnclosingRequestBase requestBase, Object requestObject) throws Exception {
                }
            };
            String recordFieldDetailsPath = ModuleFieldsHandler.getDirectory() + File.separator + converterInstance.getEncodedFileName();
            File recordFieldDetails = new File(recordFieldDetailsPath);
            if (recordFieldDetails.exists()) {
                recordFieldDetails.delete();
            }
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in deleting Current User Fields file : ", exception);
            throw exception;
        }
    }

    public static synchronized void deleteAllFieldFiles() throws SDKException {
        try {
            File[] files;
            File recordFieldDetailsDirectory = new File(ModuleFieldsHandler.getDirectory());
            if (recordFieldDetailsDirectory.exists() && (files = recordFieldDetailsDirectory.listFiles()) != null) {
                for (File file : files) {
                    if (!file.getName().endsWith(".json")) continue;
                    file.delete();
                }
            }
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in deleting all Fields files : ", exception);
            throw exception;
        }
    }

    private static void deleteFields(String module) throws SDKException {
        try {
            JSONObject recordFieldDetailsJson;
            Converter converterInstance = new Converter(){

                @Override
                public Object getWrappedResponse(Object response, String pack) throws Exception {
                    return null;
                }

                @Override
                public Object getResponse(Object response, String pack) throws Exception {
                    return null;
                }

                @Override
                public Object formRequest(Object requestInstance, String pack, Integer instanceNumber, JSONObject memberDetail) throws Exception {
                    return null;
                }

                @Override
                public void appendToRequest(HttpEntityEnclosingRequestBase requestBase, Object requestObject) throws Exception {
                }
            };
            String recordFieldDetailsPath = ModuleFieldsHandler.getDirectory() + File.separator + converterInstance.getEncodedFileName();
            File recordFieldDetails = new File(recordFieldDetailsPath);
            if (recordFieldDetails.exists() && (recordFieldDetailsJson = Initializer.getJSON(recordFieldDetailsPath)).has(module.toLowerCase())) {
                Utility.deleteFields(recordFieldDetailsJson, module);
                FileWriter file = new FileWriter(recordFieldDetailsPath);
                file.flush();
                file.write(recordFieldDetailsJson.toString());
                file.flush();
                file.close();
            }
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            throw exception;
        }
    }

    public static synchronized void refreshFields(String module) throws SDKException {
        try {
            ModuleFieldsHandler.deleteFields(module);
            Utility.getFieldsInfo(module, null);
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception in refreshing fields of module : ".concat(module), e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in refreshing fields of module : ".concat(module), exception);
            throw exception;
        }
    }

    public static synchronized void refreshAllModules() throws SDKException {
        try {
            Utility.refreshModules();
        }
        catch (SDKException e) {
            LOGGER.log(Level.SEVERE, "Exception in refreshing fields of all modules : ", e);
            throw e;
        }
        catch (Exception e) {
            SDKException exception = new SDKException(e);
            LOGGER.log(Level.SEVERE, "Exception in refreshing fields of all modules : ", exception);
            throw exception;
        }
    }
}

