/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api.notes;

import com.zoho.crm.api.Header;
import com.zoho.crm.api.HeaderMap;
import com.zoho.crm.api.Param;
import com.zoho.crm.api.ParameterMap;
import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.notes.ActionHandler;
import com.zoho.crm.api.notes.BodyWrapper;
import com.zoho.crm.api.notes.ResponseHandler;
import com.zoho.crm.api.util.APIResponse;
import com.zoho.crm.api.util.CommonAPIHandler;
import java.time.OffsetDateTime;

public class NotesOperations {
    public APIResponse<ResponseHandler> getNotes(ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/Notes");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> createNotes(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/Notes");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("POST");
        handlerInstance.setCategoryMethod("CREATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateNotes(BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/Notes");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        handlerInstance.setMandatoryChecker(true);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteNotes(ParameterMap paramInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/Notes");
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        handlerInstance.setParam(paramInstance);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ResponseHandler> getNote(Long id, ParameterMap paramInstance, HeaderMap headerInstance) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/Notes/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("GET");
        handlerInstance.setCategoryMethod("READ");
        handlerInstance.setParam(paramInstance);
        handlerInstance.setHeader(headerInstance);
        return handlerInstance.apiCall(ResponseHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> updateNote(Long id, BodyWrapper request) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/Notes/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("PUT");
        handlerInstance.setCategoryMethod("UPDATE");
        handlerInstance.setContentType("application/json");
        handlerInstance.setRequest(request);
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public APIResponse<ActionHandler> deleteNote(Long id) throws SDKException {
        CommonAPIHandler handlerInstance = new CommonAPIHandler();
        String apiPath = new String();
        apiPath = apiPath.concat("/crm/v2/Notes/");
        apiPath = apiPath.concat(id.toString());
        handlerInstance.setAPIPath(apiPath);
        handlerInstance.setHttpMethod("DELETE");
        handlerInstance.setCategoryMethod("DELETE");
        return handlerInstance.apiCall(ActionHandler.class, "application/json");
    }

    public static class GetNoteHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.Notes.GetNoteHeader");
    }

    public static class GetNoteParam {
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Notes.GetNoteParam");
    }

    public static class DeleteNotesParam {
        public static final Param<Long> IDS = new Param("ids", "com.zoho.crm.api.Notes.DeleteNotesParam");
    }

    public static class GetNotesHeader {
        public static final Header<OffsetDateTime> IF_MODIFIED_SINCE = new Header("If-Modified-Since", "com.zoho.crm.api.Notes.GetNotesHeader");
    }

    public static class GetNotesParam {
        public static final Param<Integer> PAGE = new Param("page", "com.zoho.crm.api.Notes.GetNotesParam");
        public static final Param<Integer> PER_PAGE = new Param("per_page", "com.zoho.crm.api.Notes.GetNotesParam");
        public static final Param<String> FIELDS = new Param("fields", "com.zoho.crm.api.Notes.GetNotesParam");
    }
}

