/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.api;

import com.zoho.crm.api.exception.SDKException;
import com.zoho.crm.api.util.Utility;

public class RequestProxy {
    private String host;
    private Integer port;
    private String userDomain;
    private String user;
    private String password;

    private RequestProxy(String host, Integer port, String user, String password, String userDomain) {
        this.host = host;
        this.port = port;
        this.userDomain = userDomain;
        this.user = user;
        this.password = password;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUserDomain() {
        return this.userDomain;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public static class Builder {
        private String host;
        private Integer port;
        private String userDomain;
        private String user;
        private String password = "";

        public Builder host(String host) throws SDKException {
            Utility.assertNotNull(host, "REQUESTPROXY ERROR", "Host MUST NOT be null.");
            this.host = host;
            return this;
        }

        public Builder port(Integer port) throws SDKException {
            Utility.assertNotNull(port, "REQUESTPROXY ERROR", "Port MUST NOT be null.");
            this.port = port;
            return this;
        }

        public Builder userDomain(String userDomain) {
            this.userDomain = userDomain;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public RequestProxy build() throws SDKException {
            Utility.assertNotNull(this.host, "REQUESTPROXY ERROR", "Host MUST NOT be null.");
            Utility.assertNotNull(this.port, "REQUESTPROXY ERROR", "Port MUST NOT be null.");
            return new RequestProxy(this.host, this.port, this.user, this.password, this.userDomain);
        }
    }
}

