'use strict'; //NO I18N

const cliq = require('zcatalyst-integ-cliq'); //NO I18N
const axios = require('axios'); //NO I18N
const command = cliq.command();

command.executionHandler(async(req, res) => {
    let text = "";
    let url = req.arguments.trim() || "";
    if (url === "") {
        text = "Please provide the url along with this command. \nSyntax : /shortenurl <link>";
    } else {
        text = await getShortenedUrl(url);
    }
    res.setText(text);
    return res;
});

async function getShortenedUrl(url) {
    try {
        let response = await axios.post('https://cleanuri.com/api/v1/shorten', { //NO I18N
            url: url
        });
        return "Short URL : ```" + response.data.result_url + "```"; //NO I18N
    } catch (e) {
        return "Seems to be invalid URL."; //NO I18N
    }
}
