const crypto = require("crypto");   //NO I18N
const axios = require("axios"); //NO I18N

const config = require("../../config/appKeys"); //NO I18N

const CommonUtil = (function () {
    const _isValidCliqSignature = (req) => {
        let isValidSignature = false;
        const signature = req.headers["x-cliq-signature"];  //NO I18N
        if (typeof signature !== "undefined") {
            const verifier = crypto.createVerify("sha256"); //NO I18N
            verifier.update(JSON.stringify(req.body));
            isValidSignature = verifier.verify(
                config.CLIQ_APP_PUBLIC_KEY,
                signature,
                "base64"    //NO I18N
            );
        }
        return isValidSignature;
    };

    const _isEmptyString = (value) => {
        return (
            (typeof value == "string" && !value.trim()) ||  //NO I18N
            typeof value == "undefined" ||  //NO I18N
            value === null  
        );
    };

    const _isEmptyObject = (obj) => {
        return Object.keys(obj).length === 0;
    };

    const _encryptToken = (token) => {
        const iv = crypto.randomBytes(16);
        const cipher = crypto.createCipheriv(
            "aes-256-ctr",  //NO I18N
            config.WEBHOOK_TOKEN_SECRET_KEY,
            iv
        );
        const encrypted = Buffer.concat([cipher.update(token), cipher.final()]);
        return {
            iv: iv.toString("hex"), //NO I18N
            cipher: encrypted.toString("hex")  //NO I18N
        };
    };

    const _decryptToken = (iv, cipher) => {
        const decipher = crypto.createDecipheriv(
            "aes-256-ctr",  //NO I18N
            config.WEBHOOK_TOKEN_SECRET_KEY,
            Buffer.from(iv, "hex")  //NO I18N
        );
        const decrpyted = Buffer.concat([
            decipher.update(Buffer.from(cipher, "hex")),    //NO I18N
            decipher.final()
        ]);
        return decrpyted.toString();
    };

    const _getBannerResponse = (text, isFailure) => {
        let response = { type: "banner", text, status: "success" }; //NO I18N
        if (isFailure) {
            response.status = "failure";    //NO I18N
        }
        return response;
    };

    const _getAuthButtonResponse = () => ({
        text: "You haven't authorized the application yet. Authorize now to get notifications.",    //NO I18N
        card: {
            title: "Authorization", //NO I18N
            theme: "modern-inline" //NO I18N
        },
        buttons: [
            {
                label: "Authorize", //NO I18N
                type: "+",
                action: {
                    type: "invoke.function",    //NO I18N
                    data: { name: "timetrackerbtn" },   //NO I18N
                    confirm: {
                        title: "Generating webhook token to post reminder notifications",   //NO I18N
                        description: "",
                        input: { type: "user_webhook_token" }  //NO I18N
                    }
                }
            }
        ]
    });

    const _postMessageToBot = async (token, messageCard) => {
        const url = `${config.CLIQ_BOT_MESSAGE_ENDPOINT}?appkey=${config.CLIQ_APP_KEY}&zapikey=${token}`;
        await axios.post(url, messageCard);
    };

    const _getDurationFromMS = (ms) => {
        const secondsNum = parseInt(ms / 1000);
        let secondsUsed = 0;

        const days = Math.floor((secondsNum - secondsUsed) / 86400);
        if (days > 0) {
            secondsUsed += days * 86400;
        }
        const hours = Math.floor((secondsNum - secondsUsed) / 3600);
        if (hours > 0) {
            secondsUsed += hours * 3600;
        }
        const minutes = Math.floor((secondsNum - secondsUsed) / 60);
        if (minutes > 0) {
            secondsUsed += minutes * 60;
        }
        const seconds = secondsNum - secondsUsed;
        let timeString;
        if (days > 0) {
            timeString = `${days}d ${hours}h ${minutes}m ${seconds}s`;
        } else if (hours > 0) {
            timeString = `${hours}h ${minutes}m ${seconds}s`;
        } else if (minutes > 0) {
            timeString = `${minutes}m ${seconds}s`;
        } else if (seconds > 0) {
            timeString = `${seconds}s`;
        } else {
            timeString = `${days}d ${hours}h ${minutes}m ${seconds}s`;
        }

        return timeString;
    };

    const _getLocaleStringFromMS = (ms, format) => {
        const date = new Date(ms);
        if (format === "date") {
            return date.toLocaleDateString();
        } else if (format === "time") {
            return date.toLocaleTimeString();
        } else {
            return date.toLocaleString();
        }
    };

    const _capitalize = (word) => {
        return word[0].toUpperCase() + word.substring(1).toLowerCase();
    };

    return {
        isValidCliqSignature: _isValidCliqSignature,
        isEmptyString: _isEmptyString,
        isEmptyObject: _isEmptyObject,
        capitalize: _capitalize,

        encryptToken: _encryptToken,
        decryptToken: _decryptToken,

        getBannerResponse: _getBannerResponse,
        getAuthButtonResponse: _getAuthButtonResponse,

        getDurationFromMS: _getDurationFromMS,
        getLocaleStringFromMS: _getLocaleStringFromMS,

        postMessageToBot: _postMessageToBot
    };
})();

module.exports = CommonUtil;