const express = require("express"); //NO I18N
const morgan = require("morgan");   //NO I18N

const appController = require("./controllers/appController");   //NO I18N

const PORT = process.env.PORT || 8080;

const app = express();
app.use(express.json());
app.use(express.urlencoded({ extended: true }));
app.use(morgan("[:date[web]] :method :url :status :total-time ms"));

app.use("/api/v1/timetracker", appController);  //NO I18N

app.use("/",async (req, res) => {
    return res.status(200).json({
        message: "Welcome! Track time spent on your projects and task."    //NO I18N
    });
});

app.use((req, res) => {
    return res.status(404).json({
        message: "Not Found: Incorrect URL."   //NO I18N
    });
});

app.listen(PORT, async () => {
    // console.log(`APP LISTENING ON PORT ${PORT} - ${new Date()}`);
});