### Time Tracker
Track your time spent on tasks and projects using Time Tracker Bot.

Callback: POST /api/v1/timetracker

### Components
1. **Bot** - Time Tracker
    + **Bot Handlers** - Welcome Handler, Message Handler
    + **Bot Actions** - Add Task, Current Task, Projects
2. **Message Action** - Add Task
3. **Form Function** - timetrackerform
4. **Button Function** - timetrackerbtn

### Prerequisites
1. Install [Node.js](https://nodejs.org/en/) version 16 or latest.
2. Install [MySQL](https://dev.mysql.com/doc/mysql-installation-excerpt/5.7/en/) version 5.7 or latest.
3. Clone this repository using ```git clone```.

### Run the app locally
1. Get into the project directory.
2. Install the dependencies by typing ```npm install```.
3. Ensure MySQL server is active.
4. Configure the application credentials & database details in [config/dev.js](config/dev.js) file.
5. Start the application by typing ```npm start```.

### Deploy the app in Google App Engine
1. Sign In to [Google Cloud Console](https://console.cloud.google.com/).
2. Follow the below docs for deployment.
    + [Connecting Cloud SQL from App Engine standard environment](https://cloud.google.com/sql/docs/mysql/connect-app-engine-standard)
    + [Quickstart for Node.js in the standard environment](https://cloud.google.com/appengine/docs/standard/nodejs/quickstart)
3. Clone this repository in App Engine.
4. Install the dependencies and configure the credentials in [app.yaml](app.yaml) before deploying the application.
5. Update your app URL as your extension callback URL in Zoho Cliq's [developer page](https://cliq.zoho.com/developer).