const Users = require("../../models/UsersModel");	//NO I18N
const Expenses = require("../../models/ExpensesModel");	//NO I18N

const CommonUtil = require("./commonUtil");	//NO I18N

const DatabaseUtil = {
	users: (function () {
		const _doesUserExists = async (zuid) => {
			return await Users.exists({ zuid });
		};

		const _addUser = async (zuid) => {
			const doc = new Users({ zuid });
			await doc.save();
		};

		const _addToken = async (zuid, token) => {
			const doc = Users.findOneAndUpdate({ zuid }, { token: CommonUtil.encryptToken(token) });
			await doc.exec();
		};

		const _getToken = async (zuid) => {
			const doc = await Users.findOne({ zuid }, "token").lean();	//NO I18N
			if (typeof doc.token === "undefined") {
				return undefined;
			}
			return CommonUtil.decryptToken(doc.token);
		};

		const _isTokenAdded = async (zuid) => {
			const doc = await Users.findOne({ zuid }, "token").lean();	//NO I18N
			if (typeof doc.token === "undefined") {
				return false;
			}
			return true;
		};

		const _removeToken = async (zuid) => {
			const doc = await Users.findOne({ zuid });
			doc.token = undefined;
			await doc.save();
		};

		const _getUserSettings = async (zuid) => {
			const doc = await Users.findOne({ zuid }, "currency notifications").lean();	//NO I18N
			return doc;
		};

		const _getCurrency = async (zuid) => {
			const doc = await _getUserSettings(zuid);
			return doc.currency;
		};

		const _getNotificationConfig = async (zuid) => {
			const doc = await Users.findOne({ zuid }, "notifications").lean();	//NO I18N
			return doc.notifications;
		};

		const _getNotificationFrequency = async (zuid) => {
			const doc = await _getNotificationConfig(zuid);
			if (typeof doc === "undefined") {
				return undefined;
			}
			return doc.frequency;
		};

		const _getSchedulerId = async (zuid) => {
			const doc = await _getNotificationConfig(zuid);
			if (typeof doc === "undefined") {
				return undefined;
			}
			return doc.schedulerId;
		};

		const _updateSettings = async (zuid, update) => {
			const doc = Users.findOneAndUpdate({ zuid }, update);
			await doc.exec();
		};

		return {
			doesUserExists: _doesUserExists,
			addUser: _addUser,

			addToken: _addToken,
			getToken: _getToken,
			isTokenAdded: _isTokenAdded,
			removeToken: _removeToken,

			getCurrency: _getCurrency,
			updateSettings: _updateSettings,
			getUserSettings: _getUserSettings,

			getNotificationConfig: _getNotificationConfig,
			getNotificationFrequency: _getNotificationFrequency,
			getSchedulerId: _getSchedulerId
		};
	})(),

	expenses: (function () {
		const _addExpense = async (expenseData) => {
			const doc = new Expenses(expenseData);
			await doc.save();
		};

		const _getAmountSpentThisWeekAndThisMonth = async (zuid) => {
			let today = new Date();
			let pipeline = [
				{ $match: { zuid } },
				{
					$group: {
						_id: "$zuid",	//NO I18N
						thisweek: {
							$sum: {
								$cond: [
									{
										$and: [
											{ $gte: ["$date", CommonUtil.getLastMonday()] },	//NO I18N
											{ $lte: ["$date", today] }	//NO I18N
										]
									},
									"$amount",	//NO I18N
									0
								]
							}
						},
						thismonth: {
							$sum: {
								$cond: [
									{
										$and: [
											{ $gte: ["$date", CommonUtil.getFirstDayOfCurrentMonth()] },	//NO I18N
											{ $lte: ["$date", today] }	//NO I18N
										]
									},
									"$amount",	//NO I18N
									0
								]
							}
						}
					}
				}
			];
			const expense = await Expenses.aggregate(pipeline);
			return expense[0];
		};

		const _getExpense = async (zuid, fromDate, toDate) => {
			let pipeline = [
				{
					$match: {
						$and: [{ zuid: { $eq: zuid } }, { date: { $gte: fromDate, $lte: toDate } }]
					}
				},
				{ $sort: { date: -1 } },
				{
					$group: {
						_id: "$zuid",	//NO I18N
						expenses: {
							$push: {
								date: "$date",	//NO I18N
								category: "$category",	//NO I18N
								note: "$note",	//NO I18N
								amount: "$amount"	//NO I18N
							}
						}
					}
				}
			];
			let allExpenses = await Expenses.aggregate(pipeline);
			if (allExpenses.length > 0) {
				allExpenses = allExpenses[0].expenses;
			}
			return allExpenses;
		};

		const _getOverallExepenseForYear = async (zuid, fromDate, toDate) => {
			let pipeline = [
				{
					$match: {
						$and: [{ zuid: { $eq: zuid } }, { date: { $gte: fromDate, $lte: toDate } }]
					}
				},
				{
					$group: {
						_id: { $month: "$date" },	//NO I18N
						totalExpense: { $sum: "$amount" }	//NO I18N
					}
				},
				{
					$sort: { _id: 1 }
				}
			];
			const allExpenses = await Expenses.aggregate(pipeline);
			return allExpenses;
		};

		return {
			addExpense: _addExpense,
			getExpense: _getExpense,
			getOverallExepenseForYear: _getOverallExepenseForYear,
			getAmountSpentThisWeekAndThisMonth: _getAmountSpentThisWeekAndThisMonth
		};
	})()
};

module.exports = DatabaseUtil;
