const covid = require('novelcovid');

exports.getData = (req, res) => {
    (async() => {

        let sections = [];

        try {
            let countries = await covid.all();
            let rows0 = [];
            let rows1 = [];
            let elements = [];
            let i = 0;
            let iteration = 1;
            let totalcases = countries.todayCases;
            let totaldeaths = countries.todayDeaths;
            if (totalcases == 0) {
                totalcases = "-";
            } else {
                totalcases = "↑ " + totalcases;
            }
            if (totaldeaths == 0) {
                totaldeaths = "-";
            } else {
                totaldeaths = "↑ " + totaldeaths;
            }
            rows0.push({
                "Cases": countries.cases,
                "New cases": totalcases,
                "Deaths": countries.deaths,
                "New deaths": totaldeaths,
                "Recovered": countries.recovered,
                "Tests": countries.tests,
                "Affected countries": countries.affectedCountries
            });
            let table0 = {
                "type": "table",
                "headers": ["Cases", "New cases", "Deaths", "New deaths", "Recovered", "Tests", "Affected countries"],
                "rows": rows0,
                "style": {
                    "width": [15, 14, 14, 14, 14, 15, 14]
                }
            };
            elements.push(table0);
            elements.push({
                "type": "title",
                "text": "Country wise updates:"
            });
            sections.push({
                "id": 1,
                "elements": elements
            });
            elements = [];
            countries = await covid.countries({
                sort: 'cases'
            });
            for (let country of countries) {
                confirmed = country.cases;
                todayCases = country.todayCases;
                deaths = country.deaths;
                todayDeaths = country.todayDeaths;
                recovered = country.recovered;
                active = country.active;
                critical = country.critical;
                tests = country.tests;
                if (confirmed == 0) {
                    confirmed = "-";
                }
                if (todayCases == 0) {
                    todayCases = "-";
                } else {
                    todayCases = "↑ " + todayCases;
                }
                if (deaths == 0) {
                    deaths = "-";
                }
                if (todayDeaths == 0) {
                    todayDeaths = "-";
                } else {
                    todayDeaths = "↑ " + todayDeaths;
                }
                if (recovered == 0) {
                    recovered = "-";
                }
                if (active == 0) {
                    active = "-";
                }
                if (critical == 0) {
                    critical = "-";
                }
                if (tests == 0) {
                    tests = "-";
                }
                if (i > 2000) {
                    continue;
                }
                if (iteration <= 100 && i >= 0) {
                    rows1.push({
                        "S.No.": i + 1,
                        "Country": country.country,
                        "Cases": confirmed,
                        "New cases": todayCases,
                        "Deaths": deaths,
                        "New deaths": todayDeaths,
                        "Recovered": recovered,
                        "Active": active,
                        "Critical": critical,
                        "Tests": tests
                    });
                    iteration = iteration + 1;
                }
                if (iteration > 100 && i >= 0) {
                    table1 = {
                        "type": "table",
                        "headers": ["S.No.", "Country", "Cases", "New cases", "Deaths", "New deaths", "Recovered", "Active", "Critical", "Tests"],
                        "rows": rows1,
                        "style": {
                            "width": [4, 11, 11, 11, 11, 11, 11, 10, 10, 10]
                        }
                    };
                    elements.push(table1);
                    rows1 = [];
                    iteration = 1;
                }
                i = i + 1;
            }
            if (iteration < 100 && i >= 0) {
                table1 = {
                    "type": "table",
                    "headers": ["S.No.", "Country", "Cases", "New cases", "Deaths", "New deaths", "Recovered", "Active", "Critical", "Tests"],
                    "rows": rows1,
                    "style": {
                        "width": [4, 11, 11, 11, 11, 11, 11, 10, 10, 10]
                    }
                };
                elements.push(table1);
            }
            sections.push({
                "id": 2,
                "elements": elements
            });
        } catch (e) {
            console.log(e);
            res.send({
                output: {
                    "type": "widget", // NO I18N
                    "data_type": "info",
                    "info": {
                        "title": "Sorry for the inconvenience, try again later",
                        "description": "Data source temporarily down for maintenance"
                    },
                    "tabs": [{
                        "label": "Global",
                        "id": "global"
                    }],
                    "active_tab": "global"
                }
            });
        }


        res.send({
            output: {
                "type": "widget", // NO I18N
                "tabs": [{
                    "label": "Global",
                    "id": "global"
                }],
                "active_tab": "global",
                "sections": sections
            }
        });

    })();
}
