//$Id$
package com.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.zc.cliq.objects.CommandSuggestion;
import com.zc.cliq.requests.CommandHandlerRequest;
import com.zc.component.object.ZCRowObject;
import com.zc.component.zcql.ZCQL;

public class CommandHandler implements com.zc.cliq.interfaces.CommandHandler {

	@Override
	public Map<String, Object> executionHandler(CommandHandlerRequest req) throws Exception {
		String text = "";
		Map<String, Object> resp = new HashMap<String, Object>();
		List<CommandSuggestion> suggestions = req.getSelections();

		if (suggestions == null || suggestions.size() == 0) {
			text = "Please select a suggestion from the command"; //NO I18N
		} else {
			CommandSuggestion cmdSuggestion = suggestions.get(0);
			String title = cmdSuggestion.getTitle();
			String query = "SELECT * FROM notes WHERE TITLE=" + title; //NO I18N
			ArrayList<ZCRowObject> rows = ZCQL.getInstance().executeQuery(query);
			ZCRowObject row = rows.get(0);
			text = "*Title* : " + row.get("TITLE") + " \n\n*Note* : " + row.get("NOTE"); //NO I18N
		}

		resp.put("text", text);
		return resp;
	}

	@Override
	public List<CommandSuggestion> suggestionHandler(CommandHandlerRequest req) throws Exception {
		String userId = req.getUser().getId();
		String query = "SELECT * FROM notes WHERE USER_ID=" + userId; //NO I18N
		ArrayList<ZCRowObject> rows = ZCQL.getInstance().executeQuery(query);

		List<CommandSuggestion> suggestionList = new ArrayList<CommandSuggestion>();
		for (ZCRowObject row : rows) {
			CommandSuggestion suggestion = CommandSuggestion.getInstance((String) row.get("TITLE"), "", "https://i.imgur.com/ereVzNU.png");
			suggestionList.add(suggestion);
		}

		return suggestionList;
	}

}