logDir="/Library/Logs/ZohoAssist/Uninstaller"
loggedInUser=$( ioreg -n Root -d1 -a | xpath '/plist/dict/key[.="IOConsoleUsers"]/following-sibling::array/dict/key[.="kCGSSessionOnConsoleKey"]/following-sibling::*[1][name()="true"]/../key[.="kCGSSessionUserNameKey"]/following-sibling::string[1]/text()' 2>/dev/null )
userDir="/Users/$loggedInUser"
logFilePath="$logDir/uninstaller.log"
logTempFilePath="$logFilePath.tmp"
logLinesLimit=4000
unloadServices=1
removeApplications=1
terminateRunningProcess=1

# ==================== Functions ====================

# ----------------- Check Privileges ---------------
checkPrivileges()
{
    if [ $(/usr/bin/id -u) != 0 ] ; then
        /bin/echo "ALERT : You must have root permissions to successfully execute this script!"
    fi
}

# ---------------- Log Initialization --------------
initLog()
{
    : ${logDir:?}
    : ${logFilePath:?}
    : ${logTempFilePath:?}

    /bin/mkdir -p "$logDir"

    if [ -f "$logFilePath" ] ; then

    /bin/mv -f "$logFilePath" "$logTempFilePath"
    /usr/bin/tail -n $logLinesLimit "$logTempFilePath" >> "$logFilePath"
    /bin/rm -rf "$logTempFilePath"
    fi

    /bin/echo "-----------------------------------------------------------------------" >> "$logFilePath"
    /bin/echo -n " ZohoAssist Uninstall started by " >> "$logFilePath"
    /usr/bin/id -un | /usr/bin/tr "\n" " " >> "$logFilePath"
    /bin/echo -n "on " >> "$logFilePath"
    /bin/date >> "$logFilePath"
    /bin/echo "-----------------------------------------------------------------------" >> "$logFilePath"
}

# ----------------- Log and Echo --------------------
logAndEcho()
{
    if [[ $# == 2 && "$1" == "-n" ]] ; then
    /bin/echo -n "$2" | /usr/bin/tee -a "$logFilePath" 2> /dev/null
    else
    /bin/echo "$1" | /usr/bin/tee -a "$logFilePath" 2> /dev/null
    fi
}

# ----------------- Uninstall Validation ------------
checkUninstall()
{
    logAndEcho "Uninstall validation."
    didUninstall=1

    if [ -e "/Library/Application Support/ZohoAssist" ] ; then
        didUninstall=0
        logAndEcho "ZohoAssist Unattended folder exists in this system."
    fi

    if [ -e "$userDir/Library/Application Support/ZohoMeetingNative" ] ; then
        didUninstall=0
        logAndEcho "ZohoAssist Remote Support folder exists in this system."
    fi
    
    if [ -e "/Applications/ZohoAssist/UnattendedUninstaller.app" ] ; then
        didUninstall=0
        logAndEcho "UnattendedUninstaller.app exists in this system."
    fi

    if [ -e "/Library/LaunchAgents/com.zoho.assist.PerUserAgent.plist" ] ; then
        didUninstall=0
        logAndEcho "peruseragent plist exists in this system"
    fi

    if [ -e "/Library/LaunchAgents/com.zoho.assist.ZAPreLogin.plist" ] ; then
        didUninstall=0
        logAndEcho "prelogin plist exists in this system"
    fi

    if [ -e "/Library/LaunchDaemons/com.zoho.assist.ZohoUnattended.plist" ] ; then
        didUninstall=0
        logAndEcho "zohounattended daemon plist exists in this system"
    fi

    if [ -e "/Library/LaunchDaemons/com.zoho.assist.ZASystemAgent.plist" ] ; then
        didUninstall=0
        logAndEcho "zasystemagemt daemon plist exists in this system"
    fi

    logAndEcho "uninstall check complete."
    logAndEcho

    logAndEcho "-----------------------------------------------------------------------"
    if [[ $didUninstall == 1 ]] ; then
        logAndEcho " Uninstall Successful"
    else
        logAndEcho "uninstall steps failed!"
    fi
    logAndEcho "-----------------------------------------------------------------------"
}

# ===================== Script Main ================================
checkPrivileges
initLog
logAndEcho "Zoho Uninstallation started!"

if [ $unloadServices != 0 ] ; then
    logAndEcho "Unloading Launch Agents"
    cd /Library/LaunchAgents
    for current_user in `/usr/bin/users`;
    do
    sudo -u $current_user /bin/launchctl unload com.zoho.assist.PerUserAgent.plist
    sudo -u $current_user /bin/launchctl unload com.zoho.assist.ZAPreLogin.plist
    done

    logAndEcho "Unloading launch daemon"
    cd /Library/LaunchDaemons
    /bin/launchctl unload com.zoho.assist.ZohoUnattended.plist 2>&1 | /usr/bin/tee -a "$logFilePath" 2> /dev/null
    logAndEcho "Unloading system agent launch daemon"
    /bin/launchctl unload com.zoho.assist.ZASystemAgent.plist 2>&1 | /usr/bin/tee -a "$logFilePath" 2> /dev/null

    # give the services time to quit
    for ((i = 0; i < 5; i++)) ; do
    res=$(/bin/launchctl list | /usr/bin/awk '$3 == "com.zoho.assist.ZohoUnattended.plist" {print $3}')
    if [ "$res" == "" ] ; then
        break
    fi
        sleep 2
    done

    # give the systen agent services time to quit
    for ((i = 0; i < 5; i++)) ; do
    res=$(/bin/launchctl list | /usr/bin/awk '$3 == "com.zoho.assist.ZASystemAgent.plist" {print $3}')
    if [ "$res" == "" ] ; then
        break
    fi
    sleep 2
    done
fi


if [ $removeApplications != 0 ] ; then
    logAndEcho "Removing Zoho Assist applications"

    logAndEcho "Removing agent and daemons plist"
    /bin/rm -rf /Library/LaunchAgents/com.zoho.assist.PerUserAgent.plist
    /bin/rm -rf /Library/LaunchAgents/com.zoho.assist.ZAPreLogin.plist
    /bin/rm -rf /Library/LaunchDaemons/com.zoho.assist.ZohoUnattended.plist
    /bin/rm -rf /Library/LaunchDaemons/com.zoho.assist.ZASystemAgent.plist

    logAndEcho "Removing ZohoAssist Unattended"
    /bin/rm -rf "/Library/Application Support/ZohoAssist"
    /bin/rm -rf "/Applications/ZohoAssist/UnattendedUninstaller.app"
    
    logAndEcho "Removing ZohoAssist Remote Support"
    /bin/rm -rf "$userDir/Library/Application Support/ZohoMeetingNative"
    /bin/rm -rf "$userDir/Applications/Join.app"
    /bin/rm -rf "/Applications/Join.app"


    if [[ -d "/Library/Application Support/ZohoAssist" && "$(ls /Library/Application Support/ZohoAssist)" == "" ]] ; then
        /bin/rm -rf "/Library/Application Support/ZohoAssist"
    fi

    if [[ -d "/Applications/ZohoAssist" && "$(ls /Applications/ZohoAssist)" == "" ]] ; then
        /bin/rm -rf "/Applications/ZohoAssist"
    fi

fi

if [ $terminateRunningProcess != 0 ] ; then
ps -ef | grep -w "AssistUserHandler" | grep -v grep | awk '{print $2}' | xargs kill
ps -ef | grep -w "ZAPreLogin" | grep -v grep | awk '{print $2}' | xargs kill
ps -ef | grep -w "ZASystemAgent" | grep -v grep | awk '{print $2}' | xargs kill
ps -ef | grep -w "Zoho" | grep -v grep | grep -w "ZohoAssist" | awk '{print $2}' | xargs kill
ps -ef | grep -w "ZohoPingAgent" | grep -v grep | awk '{print $2}' | xargs kill
ps -ef | grep -w "ZohoUnattendedStatus" | grep -v grep | awk '{print $2}' | xargs kill
ps -ef | grep -w "ZohoAssistUpdater" | grep -v grep | awk '{print $2}' | xargs kill
ps -ef | grep -w "UnattendedUninstaller" | grep -v grep | awk '{print $2}' | xargs kill
fi

logAndEcho "...done."
logAndEcho

checkUninstall

exit 0
