/*
 * Decompiled with CFR 0.152.
 */
package attendanceclient;

import attendanceclient.AccessTokenFile;
import attendanceclient.ConfigFilter;
import attendanceclient.ConfigInfo;
import attendanceclient.LogFile;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class ZPAServerRequest {
    public static final Logger LOGGER = Logger.getLogger("ZPAServerRequest");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void sendArrayHTTPRequest(ArrayList<String> dataArr, String ftime, String ttime, Date now, boolean isFromThread) {
        LOGGER.log(Level.INFO, "\n Start of sendArrayHTTPRequest");
        int dataCount = 0;
        String refreshtoken = ConfigInfo.getConfigValue((String)"refreshtoken", (String)"", (String)"dontSetDefValue");
        LOGGER.log(Level.INFO, "\n Fetched refreshtoken");
        String targetURL = ConfigFilter.getFromConfigProperties((String)"targetURL");
        LOGGER.log(Level.INFO, "\n Fetched targetURL");
        String dateTimeFormat = "yyyy-MM-dd HH:mm:ss";
        int maxNoOfBatchUpdates = Integer.parseInt(ConfigFilter.getFromConfigProperties((String)"maxNoOfBatchUpdates", (String)"10"));
        int maxDataCount = maxNoOfBatchUpdates * 2000;
        int socketTimeOutInMins = Integer.parseInt(ConfigFilter.getFromConfigProperties((String)"socketTimeOutInMins", (String)"15"));
        try {
            if (dataArr.isEmpty()) {
                LOGGER.log(Level.INFO, "\n Returning from sendArrayHTTPRequest as dataArr is empty");
                return;
            }
            if (dataArr.toString().replaceAll("[^}]", "").length() == maxDataCount) {
                if (isFromThread) {
                    LogFile.appendLog((String)("\nERROR: Data count is more. Please sync the data by selecting dates manually(count should be less than " + maxDataCount + ")"));
                } else {
                    LogFile.appendLog((String)("\n*ERROR: Data count is more. Please reduce the date range(count should be less than " + maxDataCount + ")"));
                }
                return;
            }
            LOGGER.log(Level.INFO, "All record count {0}, data {1}", new Object[]{dataArr.toString().replaceAll("[^}]", "").length(), dataArr.toString()});
            Iterator<String> iData = dataArr.iterator();
            PostMethod post = null;
            HttpClient httpclient = new HttpClient();
            if (!ConfigInfo.getConfigValue((String)"proxyHostIP", (String)"", (String)"dontSetDefValue").equals("")) {
                httpclient.getHostConfiguration().setProxy(ConfigInfo.getConfigValue((String)"proxyHostIP", (String)"", (String)"dontSetDefValue"), Integer.parseInt(ConfigInfo.getConfigValue((String)"proxyPort", (String)"", (String)"dontSetDefValue")));
                httpclient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ConfigInfo.getConfigValue((String)"proxyUname", (String)"", (String)"dontSetDefValue"), ConfigInfo.getConfigValue((String)"proxyPwd", (String)"", (String)"dontSetDefValue")));
            }
            httpclient.getParams().setParameter("http.socket.timeout", (Object)(socketTimeOutInMins * 60000));
            LOGGER.log(Level.INFO, "before {0} {1} {2}", new Object[]{ConfigInfo.reqCount, ConfigInfo.timeTakenTotal, ConfigInfo.dataCount});
            try {
                int result = 0;
                String resp = "";
                if (!isFromThread) {
                    LogFile.appendLog((String)("*" + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(now)));
                } else if (isFromThread) {
                    LogFile.appendLog((String)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(now));
                }
                LogFile.appendLog((String)("," + ftime));
                LogFile.appendLog((String)("," + ttime));
                int itrCounter = 0;
                while (iData.hasNext()) {
                    ++itrCounter;
                    String val = iData.next();
                    dataCount = val.replaceAll("[^}]", "").length();
                    if (dataCount == 0) {
                        return;
                    }
                    if (result != 0) {
                        LogFile.appendLog((String)"\n<br>,,");
                    }
                    post = new PostMethod(targetURL);
                    String accessToken = ZPAServerRequest.fetchAccessToken((String)refreshtoken);
                    LOGGER.log(Level.INFO, "\n Fetched accessToken");
                    Header header = new Header("Authorization", "Zoho-oauthtoken " + accessToken);
                    post.addRequestHeader(header);
                    post.setParameter("dateFormat", dateTimeFormat);
                    post.setParameter("timeZone", ConfigInfo.getConfigValue((String)"timeZone", (String)"GMT", (String)"GMT"));
                    post.setParameter("data", val);
                    Date beforeReq = new Date();
                    try {
                        LOGGER.log(Level.INFO, "Before making API request");
                        result = httpclient.executeMethod((HttpMethod)post);
                        resp = post.getResponseBodyAsString();
                    }
                    catch (SocketTimeoutException e) {
                        LOGGER.log(Level.SEVERE, "Socket Timed out Exception -- Updating Status to 400");
                        result = 400;
                        resp = "failure";
                    }
                    long ms = new Date().getTime() - beforeReq.getTime();
                    String timeTaken = "";
                    if (ms >= 1000L) {
                        LOGGER.log(Level.INFO, "timeTaken {0}s", (new Date().getTime() - beforeReq.getTime()) / 1000L);
                        timeTaken = (new Date().getTime() - beforeReq.getTime()) / 1000L + "s";
                    } else {
                        LOGGER.log(Level.INFO, "timeTaken {0}ms", new Date().getTime() - beforeReq.getTime());
                        timeTaken = new Date().getTime() - beforeReq.getTime() + "ms";
                    }
                    LogFile.appendLog((String)("," + dataCount));
                    LogFile.appendLog((String)("," + result));
                    LogFile.appendLog((String)("," + timeTaken));
                    ++ConfigInfo.reqCount;
                    LOGGER.log(Level.INFO, "HTTP Response from API call: {0}", resp);
                    if (result == 200 && resp.contains("success")) {
                        LOGGER.log(Level.INFO, "HTTP Response status code: {0}", result);
                        ConfigInfo.dataCount += dataCount;
                        ConfigInfo.timeTakenTotal += ms;
                        ++ConfigInfo.reqSuccessCount;
                        if (iData.hasNext()) {
                            long sleepTime = 5000L;
                            if (itrCounter >= 5 && itrCounter < 10) {
                                sleepTime = 10000L;
                            } else if (itrCounter >= 10 && itrCounter < 15) {
                                sleepTime = 20000L;
                            } else if (itrCounter >= 15 && itrCounter < 20) {
                                sleepTime = 30000L;
                            } else if (itrCounter >= 20) {
                                sleepTime = 60000L;
                            }
                            LOGGER.log(Level.INFO, "about to sleep {0}", sleepTime);
                            Thread.sleep(sleepTime);
                        }
                        if (isFromThread && !iData.hasNext()) {
                            ConfigInfo.putLastUpdatedTime((long)now.getTime());
                        }
                        if (isFromThread) {
                            LogFile.putIntoRecord((int)1, (int)1, (int)dataCount, (long)ms);
                            continue;
                        }
                        LogFile.putIntoRecord((int)1, (int)1, (int)dataCount, (long)ms);
                        continue;
                    }
                    LogFile.putIntoRecord((int)1, (int)0, (int)0, (long)0L);
                    LOGGER.log(Level.INFO, "HTTP Response status code:{0}", result);
                    break;
                }
                LOGGER.log(Level.INFO, "After {0} {1} {2}", new Object[]{ConfigInfo.reqCount, ConfigInfo.timeTakenTotal, ConfigInfo.dataCount});
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception in Catch 1=>{0}", e);
                e.printStackTrace();
                LogFile.appendLog((String)(e + ""));
            }
            finally {
                LogFile.appendLog((String)"\n");
                if (post != null) {
                    post.releaseConnection();
                }
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception in Catch 2=>{0}", e);
            LogFile.appendLog((String)(e + ""));
        }
    }

    public static String fetchAccessToken(String refreshToken) throws IOException, JSONException, Exception {
        Boolean accessFileCreated = AccessTokenFile.accessFileCreated();
        if (accessFileCreated.booleanValue()) {
            try {
                JSONObject json = (JSONObject)AccessTokenFile.getTokenDetails(null);
                String accessTokenExpiryTimeStr = json.getString("accessTokenExpiryTime");
                String accessToken = json.getString("accessToken");
                if (System.currentTimeMillis() + 120000L < Long.parseLong(accessTokenExpiryTimeStr) && accessToken != null) {
                    LOGGER.log(Level.INFO, "Returning cached access token");
                    return accessToken;
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception in fetchAccessToken AccessTokenFile =>{0}", e);
            }
        }
        String accessToken = "";
        String clientID = ConfigInfo.getConfigValue((String)"clientID", (String)"", (String)"dontSetDefValue");
        String clientSecret = ConfigInfo.getConfigValue((String)"clientSecret", (String)"", (String)"dontSetDefValue");
        HttpClient httpclient = new HttpClient();
        if (!ConfigInfo.getConfigValue((String)"proxyHostIP", (String)"", (String)"dontSetDefValue").equals("")) {
            httpclient.getHostConfiguration().setProxy(ConfigInfo.getConfigValue((String)"proxyHostIP", (String)"", (String)"dontSetDefValue"), Integer.parseInt(ConfigInfo.getConfigValue((String)"proxyPort", (String)"", (String)"dontSetDefValue")));
            httpclient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ConfigInfo.getConfigValue((String)"proxyUname", (String)"", (String)"dontSetDefValue"), ConfigInfo.getConfigValue((String)"proxyPwd", (String)"", (String)"dontSetDefValue")));
        }
        int socketTimeOutInMins = Integer.parseInt(ConfigFilter.getFromConfigProperties((String)"socketTimeOutInMins", (String)"15"));
        httpclient.getParams().setParameter("http.socket.timeout", (Object)(socketTimeOutInMins * 60000));
        String targetURL = ConfigFilter.getFromConfigProperties((String)"accessTokenURL");
        if (targetURL == null) {
            targetURL = "https://accounts.zoho.com/oauth/v2/token";
        }
        LOGGER.log(Level.INFO, "targetURL response => {0}", targetURL);
        PostMethod post = new PostMethod(targetURL);
        post.setParameter("refresh_token", refreshToken);
        post.setParameter("client_id", clientID);
        post.setParameter("client_secret", clientSecret);
        post.setParameter("grant_type", "refresh_token");
        int result = httpclient.executeMethod((HttpMethod)post);
        LOGGER.log(Level.INFO, "fetchAccessToken Status Code => {0}", result);
        String response = post.getResponseBodyAsString();
        LOGGER.log(Level.INFO, "fetchAccessToken response => {0}", response);
        JSONObject responseJson = new JSONObject(response);
        long expiryTime = System.currentTimeMillis() + 3000000L;
        JSONObject tokenObj = new JSONObject();
        tokenObj.put("accessTokenExpiryTime", (Object)String.valueOf(expiryTime));
        tokenObj.put("accessToken", (Object)responseJson.getString("access_token"));
        AccessTokenFile.writeFile((JSONObject)tokenObj);
        return responseJson.getString("access_token");
    }
}

