/*
 * Decompiled with CFR 0.152.
 */
package attendanceclient;

import attendanceclient.ConfigFilter;
import attendanceclient.ConfigInfo;
import attendanceclient.ZPAServerRequest;
import java.util.logging.Level;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.json.JSONObject;

public class Util {
    public static String generateRT(JSONObject input) {
        try {
            HttpClient httpclient = new HttpClient();
            if (!ConfigInfo.getConfigValue((String)"proxyHostIP", (String)"", (String)"dontSetDefValue").equals("")) {
                httpclient.getHostConfiguration().setProxy(ConfigInfo.getConfigValue((String)"proxyHostIP", (String)"", (String)"dontSetDefValue"), Integer.parseInt(ConfigInfo.getConfigValue((String)"proxyPort", (String)"", (String)"dontSetDefValue")));
                httpclient.getState().setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ConfigInfo.getConfigValue((String)"proxyUname", (String)"", (String)"dontSetDefValue"), ConfigInfo.getConfigValue((String)"proxyPwd", (String)"", (String)"dontSetDefValue")));
            }
            int socketTimeOutInMins = Integer.parseInt(ConfigFilter.getFromConfigProperties((String)"socketTimeOutInMins", (String)"30"));
            httpclient.getParams().setParameter("http.socket.timeout", (Object)(socketTimeOutInMins * 60000));
            String dcType = input.getString("dcType");
            String targetURL = "https://accounts.zoho.com/oauth/v2/token";
            if (dcType.equals("2")) {
                targetURL = "https://accounts.zoho.in/oauth/v2/token";
            } else if (dcType.equals("3")) {
                targetURL = "https://accounts.zoho.eu/oauth/v2/token";
            } else if (dcType.equals("4")) {
                targetURL = "https://accounts.zoho.com.au/oauth/v2/token";
            } else if (dcType.equals("5")) {
                targetURL = "https://accounts.zoho.com.cn/oauth/v2/token";
            }
            ZPAServerRequest.LOGGER.log(Level.INFO, "generateRT targetURL => {0}", targetURL);
            PostMethod post = new PostMethod(targetURL);
            post.setParameter("code", input.getString("code"));
            post.setParameter("client_id", input.getString("clientId"));
            post.setParameter("client_secret", input.getString("clientSecret"));
            post.setParameter("grant_type", "authorization_code");
            int result = httpclient.executeMethod((HttpMethod)post);
            ZPAServerRequest.LOGGER.log(Level.INFO, "generateRT Status Code => {0}", result);
            String response = post.getResponseBodyAsString();
            ZPAServerRequest.LOGGER.log(Level.INFO, "generateRT response => {0}", response);
            JSONObject responseJson = new JSONObject(response);
            return responseJson.getString("refresh_token");
        }
        catch (Exception e) {
            ZPAServerRequest.LOGGER.log(Level.SEVERE, "Exception in generateRT => {0}", e);
            ZPAServerRequest.LOGGER.log(Level.SEVERE, "Returning empty string");
            return "";
        }
    }
}

