/*
 * Decompiled with CFR 0.152.
 */
package attendanceclient;

import attendanceclient.ConfigInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class LogFile {
    public static final Logger LOGGER = Logger.getLogger("LogFile");
    private static FileHandler fh = null;

    public static synchronized void appendLog(String logs) {
        try {
            String pattern = LogFile.getLogFilePattern();
            File file = new File(pattern);
            if (!file.exists()) {
                ConfigInfo.clearStatInfo();
                file.createNewFile();
                LogFile.deleteOldFiles();
            }
            FileWriter fileWritter = new FileWriter(file.getName(), true);
            BufferedWriter bufferWritter = new BufferedWriter(fileWritter);
            bufferWritter.write(logs);
            bufferWritter.close();
        }
        catch (IOException ex) {
            Logger.getLogger(LogFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getFromRecord(String name) {
        FileReader readRecord = null;
        JSONObject getJson = null;
        String todayDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date(ConfigInfo.getDelaySysDate()));
        try {
            readRecord = new FileReader("record");
            JSONParser parser = new JSONParser();
            Object obj = parser.parse((Reader)readRecord);
            JSONObject jsonObj = (JSONObject)obj;
            if (jsonObj.containsKey((Object)todayDate) && name == "fullData") {
                getJson = (JSONObject)jsonObj.get((Object)todayDate);
            } else {
                if (!jsonObj.containsKey((Object)todayDate) && name == "fullData") {
                    JSONObject jSONObject = jsonObj;
                    return jSONObject;
                }
                if (!jsonObj.containsKey((Object)name)) {
                    JSONObject jSONObject = getJson = null;
                    return jSONObject;
                }
                getJson = (JSONObject)jsonObj.get((Object)name);
            }
            long timeTakenTotal = (Long)getJson.get((Object)"totalTimeTaken");
            long reqCount = (Long)getJson.get((Object)"reqCount");
            long reqSuccessCount = (Long)getJson.get((Object)"reqSuccessCount");
            getJson.put((Object)"reqFailCount", (Object)(reqCount - reqSuccessCount));
            if (timeTakenTotal != 0L && reqCount != 0L) {
                long ms = timeTakenTotal / reqCount;
                if (ms >= 1000L) {
                    getJson.put((Object)"averageTimeTaken", (Object)(timeTakenTotal / reqCount / 1000L + "s"));
                } else {
                    getJson.put((Object)"averageTimeTaken", (Object)(timeTakenTotal / reqCount + "ms"));
                }
            } else {
                getJson.put((Object)"averageTimeTaken", (Object)0);
            }
            if (name == "fullData") {
                JSONObject jSONObject = jsonObj;
                return jSONObject;
            }
            JSONObject jSONObject = getJson;
            return jSONObject;
        }
        catch (IOException parser) {
        }
        catch (ParseException ex) {
            Logger.getLogger(LogFile.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                if (readRecord != null) {
                    readRecord.close();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(LogFile.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return null;
    }

    public static Long getRequestTime() {
        FileReader readRecord = null;
        Long val = null;
        try {
            readRecord = new FileReader("record");
            JSONParser parser = new JSONParser();
            Object obj = parser.parse((Reader)readRecord);
            JSONObject jsonObj = (JSONObject)obj;
            if (jsonObj.containsKey((Object)"lastRequestDate")) {
                val = Long.parseLong(jsonObj.get((Object)"lastRequestDate").toString());
            }
        }
        catch (IOException e) {
            Logger.getLogger(LogFile.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (NumberFormatException e) {
            Logger.getLogger(LogFile.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (ParseException e) {
            Logger.getLogger(LogFile.class.getName()).log(Level.SEVERE, null, e);
        }
        return val;
    }

    public static synchronized void putIntoRecord(int reqCount, int reqSuccessCount, int dataCount, long totalTimeTaken) {
        boolean isFirstTime = false;
        FileReader readRecord = null;
        JSONObject entry = new JSONObject();
        long reqCnt = 0L;
        long reqSuccessCnt = 0L;
        long dataCnt = 0L;
        long totalTime = 0L;
        String todayDate = new SimpleDateFormat("yyyy-MM-dd").format(new Date(ConfigInfo.getDelaySysDate()));
        try {
            JSONObject jsonObj;
            File file = new File("record");
            if (!file.exists()) {
                isFirstTime = true;
                file.createNewFile();
            }
            if (isFirstTime) {
                jsonObj = new JSONObject();
            } else {
                JSONParser parser = new JSONParser();
                readRecord = new FileReader("record");
                Object obj = parser.parse((Reader)readRecord);
                jsonObj = (JSONObject)obj;
                if (jsonObj.containsKey((Object)todayDate)) {
                    JSONObject getJson = (JSONObject)jsonObj.get((Object)todayDate);
                    reqCnt = (Long)getJson.get((Object)"reqCount");
                    reqSuccessCnt = (Long)getJson.get((Object)"reqSuccessCount");
                    dataCnt = (Long)getJson.get((Object)"dataCount");
                    totalTime = (Long)getJson.get((Object)"totalTimeTaken");
                }
            }
            entry.put((Object)"reqCount", (Object)(reqCnt + (long)reqCount));
            entry.put((Object)"reqSuccessCount", (Object)(reqSuccessCnt + (long)reqSuccessCount));
            entry.put((Object)"dataCount", (Object)(dataCnt + (long)dataCount));
            entry.put((Object)"totalTimeTaken", (Object)(totalTime + totalTimeTaken));
            jsonObj.put((Object)todayDate, (Object)entry);
            FileWriter fileWritter = new FileWriter(file.getName());
            fileWritter.write(jsonObj.toJSONString());
            fileWritter.flush();
            fileWritter.close();
        }
        catch (IOException file) {
        }
        catch (ParseException ex) {
            Logger.getLogger(LogFile.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static String getLogFilePattern() {
        String pattern = "zpa_logs_" + new SimpleDateFormat("yyyy-MM-dd").format(new Date(ConfigInfo.getDelaySysDate())) + ".log";
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getLogs(String fileName) {
        InputStreamReader fr = null;
        StringBuilder logs = new StringBuilder();
        try {
            File file;
            if (fileName == null) {
                fileName = LogFile.getLogFilePattern();
            }
            if ((file = new File(fileName)).exists()) {
                String sRow;
                fr = new FileReader(file);
                BufferedReader br = new BufferedReader(fr);
                while ((sRow = br.readLine()) != null) {
                    if (sRow.contains("server request") || sRow.contains("AttendanceThread")) continue;
                    if (sRow.startsWith("INFO")) {
                        sRow = sRow.replace("INFO:", "");
                        sRow = "<tr><td></td><td>" + sRow.replaceAll("\t", "</td><td>") + "</td></tr>";
                    } else {
                        sRow = "<tr><td></td><td>" + sRow.replaceAll(",", "</td><td>") + "</td></tr>";
                    }
                    logs.insert(0, sRow);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fr != null) {
                    fr.close();
                }
            }
            catch (Exception exception) {}
        }
        return logs;
    }

    public static void deleteOldFiles() {
        LocalDate date = LocalDate.now();
        date = date.minusMonths(3L);
        DateTimeFormatter dFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        Boolean stopDelete = false;
        int count = 0;
        while (!stopDelete.booleanValue()) {
            String fileName = "zpa_logs_" + date.format(dFormat) + ".log";
            File file = new File(fileName);
            if (file.exists()) {
                LOGGER.log(Level.INFO, "{0} file deleted..", fileName);
                file.delete();
                count = 0;
            } else {
                ++count;
            }
            date = date.minusDays(1L);
            if (count <= 10) continue;
            stopDelete = true;
        }
        LOGGER.log(Level.INFO, "File deletion completed");
    }

    public static JSONArray listFilesForFolder() {
        JSONArray arr = new JSONArray();
        File folder = new File(".");
        for (File fileEntry : folder.listFiles()) {
            String fileName = fileEntry.getName();
            if (!fileName.endsWith(".log")) continue;
            arr.put((Object)fileName.substring(9).replace(".log", ""));
        }
        return arr;
    }
}

