/*
 * Decompiled with CFR 0.152.
 */
package attendanceclient;

import DatabaseUtil.ConnectToDatabase;
import attendanceclient.ConfigInfo;
import attendanceclient.ZPAServerRequest;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

/*
 * Exception performing whole class analysis ignored.
 */
public class AttendanceThread
extends Thread {
    protected static boolean startSync = false;
    private static int requestCount = 0;
    private boolean isStopped = true;
    public static final Logger LOGGER = Logger.getLogger("AttendanceThread");

    public boolean isRunning() {
        return !this.isStopped;
    }

    public void startSync() throws Exception {
        LOGGER.log(Level.INFO, "\n\n\n\n\n\n\n  START sync called==>>" + this.isStopped + "====" + this.isAlive());
        requestCount = 0;
        this.isStopped = false;
        if (this.isAlive()) {
            return;
        }
        JSONObject json = new JSONObject();
        json.put("syncMode", 1);
        ConfigInfo.setConfigInfo((JSONObject)json);
        TimeZone.setDefault(TimeZone.getTimeZone(ConfigInfo.getConfigValue((String)"timeZone", (String)"GMT", (String)"GMT")));
        this.start();
    }

    public void stopSync() throws Exception {
        LOGGER.log(Level.INFO, "\n\n\n STOP sync called ");
        JSONObject json = new JSONObject();
        json.put("syncMode", 0);
        ConfigInfo.setConfigInfo((JSONObject)json);
        this.isStopped = true;
    }

    public static void resetCount() {
        requestCount = 0;
    }

    @Override
    public void run() {
        LOGGER.log(Level.INFO, "\n\n Start of thread run checking isStopped = {0}", new Object[]{this.isStopped});
        while (!this.isStopped) {
            try {
                Runtime runtime = Runtime.getRuntime();
                NumberFormat format = NumberFormat.getInstance();
                long maxMemory = runtime.maxMemory();
                long allocatedMemory = runtime.totalMemory();
                long freeMemory = runtime.freeMemory();
                LOGGER.log(Level.INFO, "\n free memory: " + format.format(freeMemory / 0x100000L));
                LOGGER.log(Level.INFO, "\n allocated memory: " + format.format(allocatedMemory / 0x100000L));
                LOGGER.log(Level.INFO, "\n max memory: " + format.format(maxMemory / 0x100000L));
                LOGGER.log(Level.INFO, "\n total free memory: " + format.format((freeMemory + (maxMemory - allocatedMemory)) / 0x100000L));
                String dateformat = "yyyy-MM-dd HH:mm:ss";
                Date delay = new Date(ConfigInfo.getDelaySysDate());
                String ftime = new SimpleDateFormat(dateformat).format(ConfigInfo.getLastUpdatedTime());
                String delayedDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(delay);
                LOGGER.log(Level.INFO, "\n\n\n\n  thread run {0} ===== {1}", new Object[]{ftime, delayedDate});
                ZPAServerRequest.sendArrayHTTPRequest((ArrayList)new ConnectToDatabase().databaseConnection(ftime, delayedDate), (String)ftime, (String)delayedDate, (Date)delay, (boolean)true);
                LOGGER.log(Level.INFO, "\n After ZPAServerRequest");
                ConfigInfo.writeFile();
                LOGGER.log(Level.INFO, "\n After ConfigInfo writefile");
                long sleepTime = ConfigInfo.getSleepTime();
                LOGGER.log(Level.INFO, "\n Sleeping for {0}", sleepTime);
                AttendanceThread.sleep((long)sleepTime);
                LOGGER.log(Level.INFO, "\n Sleep function end");
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, null, ex);
                try {
                    long sleepTime = ConfigInfo.getSleepTime();
                    AttendanceThread.sleep((long)sleepTime);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, null, ex);
                    try {
                        this.stopSync();
                    }
                    catch (Exception exp) {
                        LOGGER.log(Level.SEVERE, null, exp);
                    }
                }
            }
        }
    }
}

