/*
 * Decompiled with CFR 0.152.
 */
package attendanceclient;

import attendanceclient.ConfigInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class AccessTokenFile {
    public static final Logger LOGGER = Logger.getLogger("AccessTokenFile");

    public static Boolean accessFileCreated() {
        try {
            File file = new File(".token");
            return file.exists();
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "\n\n\n Exception in accessFileCreated {0}", new Object[]{e});
            return false;
        }
    }

    public static synchronized void writeFile(JSONObject tokenObj) throws Exception {
        LOGGER.log(Level.INFO, "\n Started writing AccessTokenFile");
        File file = new File(".token");
        FileWriter fw = new FileWriter(file.getAbsoluteFile());
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(ConfigInfo.encrypt((String)tokenObj.toString()));
        bw.close();
        fw.close();
        LOGGER.log(Level.INFO, "\n\n\n AccessTokenFile write completed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Object getTokenDetails(String key) {
        LOGGER.log(Level.INFO, "\n\n\n getTokenDetails called {0} ", new Object[]{key});
        FileInputStream fis = null;
        try {
            File file = new File(".token");
            if (file.exists()) {
                fis = new FileInputStream(file);
                byte[] data = new byte[(int)file.length()];
                fis.read(data);
                fis.close();
                JSONObject tokenObj = new JSONObject(ConfigInfo.decrypt((String)new String(data, "UTF-8")));
                if (key != null) {
                    String string = tokenObj.getString(key);
                    return string;
                }
                JSONObject jSONObject = tokenObj;
                return jSONObject;
            }
            Object var3_6 = null;
            return var3_6;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "\n\n\n Exception in getTokenDetails {0}", new Object[]{e});
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

