/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.oauth.common;

import com.zoho.oauth.client.ZohoOAuthClient;
import com.zoho.oauth.common.ZohoOAuthException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZohoOAuthUtil {
    protected static final Logger LOGGER = Logger.getLogger(ZohoOAuthClient.class.getName());

    public static HashMap<String, String> getFileAsMap(String filePath) throws IOException, ZohoOAuthException {
        return ZohoOAuthUtil.getFileAsMap(new FileInputStream(filePath));
    }

    public static HashMap<String, String> getFileAsMap(InputStream ins) throws IOException {
        try {
            if (ins == null) {
                throw new Error("File not found.");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            BufferedReader br = new BufferedReader(new InputStreamReader(ins));
            String line = null;
            while ((line = br.readLine()) != null) {
                Object[] props = line.split("=");
                if (props[0].startsWith("#")) continue;
                String key = props[0];
                String val = null;
                if (props.length == 2) {
                    val = props[1];
                } else if (props.length > 2) {
                    props[0] = "";
                    String str = Arrays.toString(props);
                    val = str.substring(3, str.length() - 1).replace(", ", "=");
                }
                map.put(key, val);
            }
            ins.close();
            return map;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception while loading file as map.");
            throw e;
        }
    }
}

