/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.crud;

import com.zoho.crm.library.api.handler.EntityAPIHandler;
import com.zoho.crm.library.api.handler.MassEntityAPIHandler;
import com.zoho.crm.library.api.handler.ModuleAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.ZCRMEntity;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.setup.users.ZCRMProfile;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import java.util.List;

public class ZCRMModule
extends ZCRMEntity {
    private String systemName;
    private String apiName;
    private String singularLabel;
    private String pluralLabel;
    private Long id;
    private String generatedType;
    private boolean creatable;
    private boolean viewable;
    private boolean convertible;
    private boolean deletable;
    private boolean editable;
    private Integer visibility;
    private ZCRMUser modifiedBy;
    private String modifiedTime;
    private List<String> businessCardFields = new ArrayList<String>();
    private List<ZCRMProfile> accessibleProfiles = new ArrayList<ZCRMProfile>();

    protected ZCRMModule(String apiName) {
        this.apiName = apiName;
    }

    public static ZCRMModule getInstance(String apiName) {
        return new ZCRMModule(apiName);
    }

    public String getApiName() {
        return this.apiName;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getId() {
        return this.id;
    }

    public void setSystemName(String sysName) {
        this.systemName = sysName;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSingularLabel(String singularLabel) {
        this.singularLabel = singularLabel;
    }

    public String getSingularLabel() {
        return this.singularLabel;
    }

    public void setPluralLabel(String pluralLabel) {
        this.pluralLabel = pluralLabel;
    }

    public String getPluralLabel() {
        return this.pluralLabel;
    }

    public void setConvertible(boolean convertible) {
        this.convertible = convertible;
    }

    public boolean isConvertible() {
        return this.convertible;
    }

    public void setCreatable(boolean creatable) {
        this.creatable = creatable;
    }

    public boolean isCreatable() {
        return this.creatable;
    }

    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setViewable(boolean viewable) {
        this.viewable = viewable;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public void setGeneratedType(String generatedType) {
        this.generatedType = generatedType;
    }

    public String getGeneratedType() {
        return this.generatedType;
    }

    public void setVisibility(Integer visibility) {
        this.visibility = visibility;
    }

    public Integer getVisibility() {
        return this.visibility;
    }

    public void setModifiedBy(ZCRMUser user) {
        this.modifiedBy = user;
    }

    public ZCRMUser getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedTime(String time) {
        this.modifiedTime = time;
    }

    public String getModifiedTime() {
        return this.modifiedTime;
    }

    public void setBusinessCardFields(List<String> bcFields) {
        this.businessCardFields = bcFields;
    }

    public List<String> getBusinessCardFields() {
        return this.businessCardFields;
    }

    public BulkAPIResponse getRelatedLists() throws ZCRMException {
        return ModuleAPIHandler.getInstance(this).getAllRelatedLists();
    }

    public APIResponse getRelatedList(Long relatedlistId) throws ZCRMException {
        return ModuleAPIHandler.getInstance(this).getRelatedList(relatedlistId);
    }

    public BulkAPIResponse getAllFields() throws ZCRMException {
        return this.getAllFields(null);
    }

    private BulkAPIResponse getAllFields(String modifiedSince) throws ZCRMException {
        return ModuleAPIHandler.getInstance(this).getAllFields(modifiedSince);
    }

    public APIResponse getField(Long fieldId) throws ZCRMException {
        return ModuleAPIHandler.getInstance(this).getField(fieldId);
    }

    public BulkAPIResponse getLayouts() throws ZCRMException {
        return this.getLayouts(null);
    }

    public BulkAPIResponse getLayouts(String modifiedSince) throws ZCRMException {
        return ModuleAPIHandler.getInstance(this).getAllLayouts(modifiedSince);
    }

    public APIResponse getLayoutDetails(Long layoutId) throws ZCRMException {
        return ModuleAPIHandler.getInstance(this).getLayoutDetails(layoutId);
    }

    public BulkAPIResponse getCustomViews() throws ZCRMException {
        return this.getCustomViews(null);
    }

    private BulkAPIResponse getCustomViews(String modifiedSince) throws ZCRMException {
        return ModuleAPIHandler.getInstance(this).getAllCustomViews(modifiedSince);
    }

    public APIResponse getCustomView(long cvID) throws ZCRMException {
        return ModuleAPIHandler.getInstance(this).getCustomView(cvID);
    }

    public BulkAPIResponse createRecords(List<ZCRMRecord> records) throws ZCRMException {
        if (records == null || records.isEmpty()) {
            throw new ZCRMException("Record list MUST NOT be null for create operation.");
        }
        return MassEntityAPIHandler.getInstance(this).createRecords(records, null);
    }

    public BulkAPIResponse createRecords(List<ZCRMRecord> records, List<CommonUtil.Trigger> triggers) throws ZCRMException {
        if (records == null || records.isEmpty()) {
            throw new ZCRMException("Record list MUST NOT be null for create operation.");
        }
        return MassEntityAPIHandler.getInstance(this).createRecords(records, triggers);
    }

    public BulkAPIResponse updateRecords(List<Long> entityIds, String fieldAPIName, Object value) throws ZCRMException {
        if (entityIds == null || entityIds.isEmpty()) {
            throw new ZCRMException("Entity ID list MUST NOT be null/empty for update operation.");
        }
        return MassEntityAPIHandler.getInstance(this).updateRecords(entityIds, fieldAPIName, value, null);
    }

    public BulkAPIResponse updateRecords(List<Long> entityIds, String fieldAPIName, Object value, List<CommonUtil.Trigger> triggers) throws ZCRMException {
        if (entityIds == null || entityIds.isEmpty()) {
            throw new ZCRMException("Entity ID list MUST NOT be null/empty for update operation.");
        }
        return MassEntityAPIHandler.getInstance(this).updateRecords(entityIds, fieldAPIName, value, triggers);
    }

    public BulkAPIResponse upsertRecords(List<ZCRMRecord> records) throws ZCRMException {
        if (records == null || records.isEmpty()) {
            throw new ZCRMException("Record list MUST NOT be null/empty for upsert operation.");
        }
        return MassEntityAPIHandler.getInstance(this).upsertRecords(records, null);
    }

    public BulkAPIResponse upsertRecords(List<ZCRMRecord> records, List<CommonUtil.Trigger> triggers) throws ZCRMException {
        if (records == null || records.isEmpty()) {
            throw new ZCRMException("Record list MUST NOT be null/empty for upsert operation.");
        }
        return MassEntityAPIHandler.getInstance(this).upsertRecords(records, triggers);
    }

    public BulkAPIResponse deleteRecords(List<Long> entityIds) throws ZCRMException {
        if (entityIds == null || entityIds.isEmpty()) {
            throw new ZCRMException("Entity ID list MUST NOT be null/empty for delete operation.");
        }
        return MassEntityAPIHandler.getInstance(this).deleteRecords(entityIds);
    }

    public APIResponse getRecord(Long entityId) throws ZCRMException {
        ZCRMRecord record = ZCRMRecord.getInstance(this.apiName, entityId);
        return EntityAPIHandler.getInstance(record).getRecord(false);
    }

    public APIResponse getRecord(Long entityId, Boolean includePrivateFields) throws ZCRMException {
        ZCRMRecord record = ZCRMRecord.getInstance(this.apiName, entityId);
        return EntityAPIHandler.getInstance(record).getRecord(includePrivateFields);
    }

    public BulkAPIResponse getRecords() throws ZCRMException {
        return this.getRecords(false);
    }

    public BulkAPIResponse getRecords(Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(null, null, includePrivateFields);
    }

    public BulkAPIResponse getRecords(Long cvId) throws ZCRMException {
        return this.getRecords(cvId, (Boolean)false);
    }

    public BulkAPIResponse getRecords(Long cvId, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(cvId, null, includePrivateFields);
    }

    public BulkAPIResponse getRecords(List<String> fields) throws ZCRMException {
        return this.getRecords(null, fields, false);
    }

    public BulkAPIResponse getRecords(List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(null, fields, includePrivateFields);
    }

    public BulkAPIResponse getRecords(Long cvId, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(cvId, null, null, 1, 200, fields, includePrivateFields);
    }

    public BulkAPIResponse getRecords(Long cvId, int page, int per_page) throws ZCRMException {
        return this.getRecords(cvId, null, null, page, per_page, null, false);
    }

    public BulkAPIResponse getRecords(Long cvId, int page, int per_page, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(cvId, null, null, page, per_page, null, includePrivateFields);
    }

    public BulkAPIResponse getRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder) throws ZCRMException {
        return this.getRecords(cvId, sortByField, sortOrder, 1, 200, null, false);
    }

    public BulkAPIResponse getRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(cvId, sortByField, sortOrder, 1, 200, null, includePrivateFields);
    }

    public BulkAPIResponse getRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, List<String> fields) throws ZCRMException {
        return this.getRecords(cvId, sortByField, sortOrder, page, per_page, null, fields, false);
    }

    public BulkAPIResponse getRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return this.getRecords(cvId, sortByField, sortOrder, page, per_page, null, fields, includePrivateFields);
    }

    public BulkAPIResponse getRecords(String modifiedSince, Boolean includePrivateFields) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getRecords(null, null, null, 1, 200, modifiedSince, null, null, null, includePrivateFields);
    }

    public BulkAPIResponse getRecords(Long cvId, String modifiedSince, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getRecords(cvId, null, null, 1, 200, modifiedSince, null, null, fields, includePrivateFields);
    }

    public BulkAPIResponse getRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getRecords(cvId, sortByField, sortOrder, page, per_page, modifiedSince, null, null, fields, includePrivateFields);
    }

    public BulkAPIResponse getRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince, Boolean isConverted, Boolean isApproved, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getRecords(cvId, sortByField, sortOrder, page, per_page, modifiedSince, String.valueOf(isConverted), String.valueOf(isApproved), fields, includePrivateFields);
    }

    public BulkAPIResponse getConvertedRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getRecords(cvId, sortByField, sortOrder, page, per_page, modifiedSince, "true", null, fields, includePrivateFields);
    }

    public BulkAPIResponse getUnConvertedRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getRecords(cvId, sortByField, sortOrder, page, per_page, modifiedSince, "false", null, fields, includePrivateFields);
    }

    public BulkAPIResponse getApprovedRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getRecords(cvId, sortByField, sortOrder, page, per_page, modifiedSince, null, "true", fields, includePrivateFields);
    }

    public BulkAPIResponse getUnApprovedRecords(Long cvId, String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince, List<String> fields, Boolean includePrivateFields) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getRecords(cvId, sortByField, sortOrder, page, per_page, modifiedSince, null, "false", fields, includePrivateFields);
    }

    @Deprecated
    public BulkAPIResponse getAllDeletedRecords() throws ZCRMException {
        return this.getAllDeletedRecords(null);
    }

    @Deprecated
    public BulkAPIResponse getAllDeletedRecords(String modifiedSince) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getDeletedRecords("all", modifiedSince, 1, 200);
    }

    public BulkAPIResponse getDeletedRecords() throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getDeletedRecords("all", null, 1, 200);
    }

    public BulkAPIResponse getDeletedRecords(String modifiedSince) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getDeletedRecords("all", modifiedSince, 1, 200);
    }

    public BulkAPIResponse getDeletedRecords(String modifiedSince, int page, int perPage) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getDeletedRecords("all", modifiedSince, page, perPage);
    }

    public BulkAPIResponse getDeletedRecords(int page, int perPage) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getDeletedRecords("all", null, page, perPage);
    }

    public BulkAPIResponse getRecycleBinRecords() throws ZCRMException {
        return this.getRecycleBinRecords(null);
    }

    public BulkAPIResponse getRecycleBinRecords(String modifiedSince) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getDeletedRecords("recycle", modifiedSince, 1, 200);
    }

    public BulkAPIResponse getPermanentlyDeletedRecords() throws ZCRMException {
        return this.getPermanentlyDeletedRecords(null);
    }

    public BulkAPIResponse getPermanentlyDeletedRecords(String modifiedSince) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).getDeletedRecords("permanent", modifiedSince, 1, 200);
    }

    public BulkAPIResponse searchByText(String searchText) throws ZCRMException {
        return this.searchByText(searchText, 1, 200);
    }

    public BulkAPIResponse searchByText(String searchText, int page, int per_page) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).searchByText(searchText, page, per_page);
    }

    public BulkAPIResponse searchByCriteria(String searchCriteria) throws ZCRMException {
        return this.searchByCriteria(searchCriteria, 1, 200);
    }

    public BulkAPIResponse searchByCriteria(String searchCriteria, int page, int per_page) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).searchByCriteria(searchCriteria, page, per_page);
    }

    public BulkAPIResponse searchByPhone(String value) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).searchByPhone(value, 1, 200);
    }

    public BulkAPIResponse searchByPhone(String value, int page, int per_page) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).searchByPhone(value, page, per_page);
    }

    public BulkAPIResponse searchByEmail(String value) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).searchByEmail(value, 1, 200);
    }

    public BulkAPIResponse searchByEmail(String value, int page, int per_page) throws ZCRMException {
        return MassEntityAPIHandler.getInstance(this).searchByEmail(value, page, per_page);
    }

    public void addAccessibleProfile(ZCRMProfile profile) {
        this.accessibleProfiles.add(profile);
    }

    public List<ZCRMProfile> getAccessibleProfiles() {
        return this.accessibleProfiles;
    }
}

