/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.api.response.FileAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.common.ZCRMConfigUtil;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.users.ZCRMProfile;
import com.zoho.crm.library.setup.users.ZCRMRole;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UserAPIHandler
extends CommonAPIHandler
implements APIHandler {
    private UserAPIHandler() {
    }

    public static UserAPIHandler getInstance() {
        return new UserAPIHandler();
    }

    public APIResponse getUser(Long userId) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            if (userId != null) {
                this.urlPath = "users/" + userId;
            } else {
                this.urlPath = "users";
                this.requestQueryParams.put("type", (Object)"CurrentUser");
            }
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray usersArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            response.setData(this.getZCRMUser(usersArray.getJSONObject(0)));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public FileAPIResponse downloadUserPhoto(String email, CommonUtil.PhotoSize photoSize) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = ZCRMConfigUtil.getPhotoUrl() + email + "/photo";
            if (photoSize != null) {
                this.requestQueryParams.put("photo_size", (Object)photoSize.name());
            }
            return APIRequest.getInstance(this).downloadFile();
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    private BulkAPIResponse getUsers(String type, String modifiedSince, int page, int per_page) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "users";
            this.requestQueryParams.put("type", (Object)type);
            this.requestQueryParams.put("page", (Object)String.valueOf(page));
            this.requestQueryParams.put("per_page", (Object)String.valueOf(per_page));
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMUser> allUsers = new ArrayList<ZCRMUser>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray usersArray = responseJSON.optJSONArray(this.getJsonRootKey(), new JSONArray());
            for (int index = 0; index < usersArray.length(); ++index) {
                allUsers.add(this.getZCRMUser(usersArray.getJSONObject(index)));
            }
            response.setData(allUsers);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse getCurrentUser() throws ZCRMException {
        return this.getUser(null);
    }

    public BulkAPIResponse getAllUsers(String modifiedSince, int page, int per_page) throws ZCRMException {
        return this.getUsers(null, modifiedSince, page, per_page);
    }

    public BulkAPIResponse getAllActiveUsers(int page, int per_page) throws ZCRMException {
        return this.getUsers("ActiveUsers", null, page, per_page);
    }

    public BulkAPIResponse getAllDeactivedUsers(int page, int per_page) throws ZCRMException {
        return this.getUsers("DeactiveUsers", null, page, per_page);
    }

    private BulkAPIResponse getAllConfirmedUsers(int page, int per_page) throws ZCRMException {
        return this.getUsers("ConfirmedUsers", null, page, per_page);
    }

    private BulkAPIResponse getAllUnConfirmedUsers(int page, int per_page) throws ZCRMException {
        return this.getUsers("NotConfirmedUsers", null, page, per_page);
    }

    private BulkAPIResponse getAllDeletedUsers(int page, int per_page) throws ZCRMException {
        return this.getUsers("DeletedUsers", null, page, per_page);
    }

    public BulkAPIResponse getAllActiveConfirmedUsers(int page, int per_page) throws ZCRMException {
        return this.getUsers("ActiveConfirmedUsers", null, page, per_page);
    }

    public BulkAPIResponse getAllAdminUsers(int page, int per_page) throws ZCRMException {
        return this.getUsers("AdminUsers", null, page, per_page);
    }

    private BulkAPIResponse getAllActiveConfirmedAdmins(int page, int per_page) throws ZCRMException {
        return this.getUsers("ActiveConfirmedAdmins", null, page, per_page);
    }

    private ZCRMUser getZCRMUser(JSONObject userJson) throws JSONException {
        NullableJSONObject userDetails = new NullableJSONObject(userJson);
        ZCRMUser user = ZCRMUser.getInstance(Long.parseLong(userDetails.getString("id")), userDetails.getString("last_name"));
        Iterator<String> jsonItr = userDetails.keys();
        while (jsonItr.hasNext()) {
            ZCRMUser createdBy;
            JSONObject createdByObj;
            String fieldAPIName = jsonItr.next();
            if ("id".equals(fieldAPIName)) {
                user.setId(Long.parseLong(userDetails.getString(fieldAPIName)));
                continue;
            }
            if ("email".equals(fieldAPIName)) {
                user.setEmailId(userDetails.getString("email"));
                continue;
            }
            if ("first_name".equals(fieldAPIName)) {
                user.setFirstName(userDetails.getString("first_name"));
                continue;
            }
            if ("last_name".equals(fieldAPIName)) {
                user.setLastName(userDetails.getString("last_name"));
                continue;
            }
            if ("full_name".equals(fieldAPIName)) {
                user.setFullName(userDetails.getString("full_name"));
                continue;
            }
            if ("status".equals(fieldAPIName)) {
                user.setStatus(userDetails.getString("status"));
                continue;
            }
            if ("zuid".equals(fieldAPIName)) {
                user.setZUId(userDetails.optLong("zuid"));
                continue;
            }
            if ("alias".equals(fieldAPIName)) {
                user.setAlias(userDetails.optString("alias"));
                continue;
            }
            if ("confirm".equals(fieldAPIName)) {
                user.setIsConfirmed(userDetails.getBoolean("confirm"));
                continue;
            }
            if ("Created_By".equals(fieldAPIName)) {
                createdByObj = userDetails.getJSONObject("Created_By");
                createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
                user.setCreatedBy(createdBy);
                user.setCreatedTime(userDetails.getString("Created_Time"));
                continue;
            }
            if ("Modified_By".equals(fieldAPIName) && !userDetails.isNull("Modified_By")) {
                createdByObj = userDetails.getJSONObject("Modified_By");
                createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
                user.setModifiedBy(createdBy);
                user.setModifiedTime(userDetails.getString("Modified_Time"));
                continue;
            }
            if ("Reporting_To".equals(fieldAPIName)) {
                if (userDetails.isNull("Reporting_To")) continue;
                JSONObject reportingToObj = userDetails.getJSONObject("Reporting_To");
                ZCRMUser reportingTo = ZCRMUser.getInstance(Long.parseLong(reportingToObj.getString("id")), reportingToObj.getString("name"));
                user.setReportingTo(reportingTo);
                continue;
            }
            if ("profile".equals(fieldAPIName)) {
                JSONObject profileObj = userDetails.getJSONObject("profile");
                ZCRMProfile profile = ZCRMProfile.getInstance(Long.parseLong(profileObj.getString("id")), profileObj.getString("name"));
                user.setProfile(profile);
                continue;
            }
            if ("role".equals(fieldAPIName)) {
                JSONObject roleObj = userDetails.getJSONObject("role");
                ZCRMRole role = ZCRMRole.getInstance(Long.parseLong(roleObj.getString("id")), roleObj.getString("name"));
                user.setRole(role);
                continue;
            }
            if ("language".equals(fieldAPIName)) {
                user.setLanguage(userDetails.optString("language"));
                continue;
            }
            if ("mobile".equals(fieldAPIName)) {
                user.setMobile(userDetails.optString("mobile"));
                continue;
            }
            if ("city".equals(fieldAPIName)) {
                user.setCity(userDetails.optString("city"));
                continue;
            }
            if ("country_locale".equals(fieldAPIName)) {
                user.setCountryLocale(userDetails.optString("country_locale"));
                continue;
            }
            if ("date_format".equals(fieldAPIName)) {
                user.setDateFormat(userDetails.optString("date_format"));
                continue;
            }
            if ("time_format".equals(fieldAPIName)) {
                user.setTimeFormat(userDetails.optString("time_format"));
                continue;
            }
            if ("dob".equals(fieldAPIName)) {
                user.setDateOfBirth(userDetails.optString("dob"));
                continue;
            }
            if ("country".equals(fieldAPIName)) {
                user.setCountry(userDetails.optString("country"));
                continue;
            }
            if ("fax".equals(fieldAPIName)) {
                user.setFax(userDetails.optString("fax"));
                continue;
            }
            if ("locale".equals(fieldAPIName)) {
                user.setLocale(userDetails.optString("locale"));
                continue;
            }
            if ("name_format".equals(fieldAPIName)) {
                user.setNameFormat(userDetails.optString("name_format"));
                continue;
            }
            if ("phone".equals(fieldAPIName)) {
                user.setPhone(userDetails.optString("phone"));
                continue;
            }
            if ("website".equals(fieldAPIName)) {
                user.setWebsite(userDetails.optString("website"));
                continue;
            }
            if ("time_zone".equals(fieldAPIName)) {
                user.setTimeZone(userDetails.optString("time_zone"));
                continue;
            }
            if ("street".equals(fieldAPIName)) {
                user.setStreet(userDetails.optString("street"));
                continue;
            }
            if ("state".equals(fieldAPIName)) {
                user.setState(userDetails.optString("state"));
                continue;
            }
            if ("zip".equals(fieldAPIName)) {
                user.setZip(userDetails.optLong("zip"));
                continue;
            }
            user.setFieldValue(fieldAPIName, userDetails.opt(fieldAPIName));
        }
        return user;
    }

    JSONObject getZCRMUserAsJSON(ZCRMUser user) throws JSONException {
        JSONObject userObject = new JSONObject();
        userObject.put("first_name", (Object)user.getFirstName());
        userObject.put("last_name", (Object)user.getLastName());
        userObject.put("full_name", (Object)user.getFullName());
        userObject.put("alias", (Object)user.getAlias());
        userObject.put("dob", (Object)user.getDateOfBirth());
        userObject.put("mobile", (Object)user.getMobile());
        userObject.put("phone", (Object)user.getPhone());
        userObject.put("email", (Object)user.getEmailId());
        userObject.put("fax", (Object)user.getFax());
        userObject.put("street", (Object)user.getStreet());
        userObject.put("city", (Object)user.getCity());
        userObject.put("state", (Object)user.getState());
        userObject.put("country", (Object)user.getCountry());
        userObject.put("zip", (Object)user.getZip());
        userObject.put("language", (Object)user.getLanguage());
        userObject.put("locale", (Object)user.getLocale());
        userObject.put("country_locale", (Object)user.getCountryLocale());
        userObject.put("name_format", (Object)user.getNameFormat());
        userObject.put("date_format", (Object)user.getDateFormat());
        userObject.put("time_format", (Object)user.getTimeFormat());
        userObject.put("time_zone", (Object)user.getTimeZone());
        userObject.put("website", (Object)user.getWebsite());
        userObject.put("confirm", (Object)user.isConfirmed());
        userObject.put("status", (Object)user.getStatus());
        if (user.getProfile() != null) {
            userObject.put("profile", (Object)user.getProfile().getId().toString());
        }
        if (user.getRole() != null) {
            userObject.put("role", (Object)user.getRole().getId().toString());
        }
        HashMap<String, Object> userData = user.getData();
        for (String fieldAPIName : userData.keySet()) {
            Object value = userData.get(fieldAPIName);
            if (value == null) {
                value = JSONObject.NULL;
            } else if (value instanceof ZCRMRecord) {
                value = ((ZCRMRecord)value).getEntityId().toString();
            } else if (value instanceof ZCRMUser) {
                value = ((ZCRMUser)value).getId().toString();
            } else if (value instanceof ArrayList) {
                JSONArray jsonArray = new JSONArray();
                List list = (List)value;
                for (int index = 0; index < list.size(); ++index) {
                    jsonArray.put(list.get(index));
                }
                value = jsonArray;
            }
            userObject.put(fieldAPIName, value);
        }
        return userObject;
    }

    public APIResponse createUser(ZCRMUser user) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = "users";
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)this.getZCRMUserAsJSON(user));
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject responseDetails = responseData.getJSONObject("details");
            user.setId(Long.parseLong(responseDetails.getString("id")));
            response.setData(user);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse createUsers(List<ZCRMUser> users) throws ZCRMException {
        if (users.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = "users";
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (ZCRMUser user : users) {
                dataArray.put((Object)this.getZCRMUserAsJSON(user));
            }
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMUser> createdUsers = new ArrayList<ZCRMUser>();
            ArrayList<BulkAPIResponse.EntityResponse> responses = response.getEntityResponses();
            for (int i = 0; i < responses.size(); ++i) {
                BulkAPIResponse.EntityResponse entResponse = (BulkAPIResponse.EntityResponse)responses.get(i);
                if ("success".equals(entResponse.getStatus())) {
                    JSONObject responseData = entResponse.getResponseJSON();
                    JSONObject responseDetails = responseData.getJSONObject("details");
                    users.get(i).setId(Long.parseLong(responseDetails.getString("id")));
                    createdUsers.add(users.get(i));
                    entResponse.setData(users.get(i));
                    continue;
                }
                entResponse.setData(null);
            }
            response.setData(createdUsers);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse updateUser(ZCRMUser user) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.urlPath = "users/" + user.getId();
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)this.getZCRMUserAsJSON(user));
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            return APIRequest.getInstance(this).getAPIResponse();
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse updateUsers(List<ZCRMUser> users) throws ZCRMException {
        if (users.size() > 100) {
            throw new ZCRMException("Cannot process more than 100 records at a time.");
        }
        try {
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.urlPath = "users";
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            for (ZCRMUser user : users) {
                JSONObject userJson = this.getZCRMUserAsJSON(user);
                userJson.put("id", (Object)user.getId());
                dataArray.put((Object)userJson);
            }
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            return APIRequest.getInstance(this).getBulkAPIResponse();
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse deleteUser(Long userId) throws ZCRMException {
        this.requestMethod = APIConstants.RequestMethod.DELETE;
        this.urlPath = "users/" + userId;
        return APIRequest.getInstance(this).getAPIResponse();
    }

    public BulkAPIResponse searchByCriteria(String searchCriteria, int page, int per_page) throws ZCRMException {
        return this.searchUsers(searchCriteria, page, per_page);
    }

    private BulkAPIResponse searchUsers(String searchCriteria, int page, int per_page) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "users";
            this.requestQueryParams.put("filters", (Object)searchCriteria);
            this.requestQueryParams.put("page", (Object)String.valueOf(page));
            this.requestQueryParams.put("per_page", (Object)String.valueOf(per_page));
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMUser> usersList = new ArrayList<ZCRMUser>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray recordsArray = responseJSON.optJSONArray(this.getJsonRootKey(), new JSONArray());
            for (int index = 0; index < recordsArray.length(); ++index) {
                JSONObject userDetails = recordsArray.getJSONObject(index);
                usersList.add(this.getZCRMUser(userDetails));
            }
            response.setData(usersList);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    @Override
    public String getJsonRootKey() {
        return "users";
    }
}

