/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.handler.EntityAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.api.response.FileAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.crud.ZCRMAttachment;
import com.zoho.crm.library.crud.ZCRMJunctionRecord;
import com.zoho.crm.library.crud.ZCRMModuleRelation;
import com.zoho.crm.library.crud.ZCRMNote;
import com.zoho.crm.library.crud.ZCRMRecord;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RelatedListAPIHandler
extends CommonAPIHandler
implements APIHandler {
    private ZCRMRecord parentRecord;
    private ZCRMModuleRelation relatedList;
    private ZCRMJunctionRecord junctionRecord;

    private RelatedListAPIHandler(ZCRMRecord parentRecord, ZCRMModuleRelation relatedList) {
        this.parentRecord = parentRecord;
        this.relatedList = relatedList;
    }

    public static RelatedListAPIHandler getInstance(ZCRMRecord parentRecord, ZCRMModuleRelation relatedList) {
        return new RelatedListAPIHandler(parentRecord, relatedList);
    }

    private RelatedListAPIHandler(ZCRMRecord parentRecord, ZCRMJunctionRecord junctionRecord) {
        this.parentRecord = parentRecord;
        this.junctionRecord = junctionRecord;
    }

    public static RelatedListAPIHandler getInstance(ZCRMRecord parentRecord, ZCRMJunctionRecord junctionRecord) {
        return new RelatedListAPIHandler(parentRecord, junctionRecord);
    }

    public BulkAPIResponse getRecords(String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName();
            this.requestQueryParams.put("sort_by", (Object)sortByField);
            if (sortOrder != null) {
                this.requestQueryParams.put("sort_order", (Object)sortOrder.name());
            }
            this.requestQueryParams.put("page", (Object)String.valueOf(page));
            this.requestQueryParams.put("per_page", (Object)String.valueOf(per_page));
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMRecord> recordsList = new ArrayList<ZCRMRecord>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray recordsArray = responseJSON.optJSONArray("data", new JSONArray());
            for (int index = 0; index < recordsArray.length(); ++index) {
                JSONObject recordDetails = recordsArray.getJSONObject(index);
                ZCRMRecord record = ZCRMRecord.getInstance(null, Long.parseLong(recordDetails.getString("id")));
                EntityAPIHandler.getInstance(record).setRecordProperties(recordDetails);
                recordsList.add(record);
            }
            response.setData(recordsList);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getNotes(String sortByField, CommonUtil.SortOrder sortOrder, int page, int per_page, String modifiedSince) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName();
            this.requestQueryParams.put("sort_by", (Object)sortByField);
            if (sortOrder != null) {
                this.requestQueryParams.put("sort_order", (Object)sortOrder.name());
            }
            this.requestQueryParams.put("page", (Object)String.valueOf(page));
            this.requestQueryParams.put("per_page", (Object)String.valueOf(per_page));
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMNote> allNotes = new ArrayList<ZCRMNote>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray notesArray = responseJSON.optJSONArray("data", new JSONArray());
            for (int index = 0; index < notesArray.length(); ++index) {
                allNotes.add(this.getZCRMNote(notesArray.getJSONObject(index), null));
            }
            response.setData(allNotes);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse addNote(ZCRMNote note) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName();
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)this.getZCRMNoteAsJSON(note));
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject responseDetails = responseData.getJSONObject("details");
            note = this.getZCRMNote(responseDetails, note);
            response.setData(note);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse updateNote(ZCRMNote note) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.PUT;
            this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName() + '/' + note.getId();
            JSONObject requestBodyObj = new JSONObject();
            JSONArray dataArray = new JSONArray();
            dataArray.put((Object)this.getZCRMNoteAsJSON(note));
            requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
            this.requestBody = requestBodyObj;
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject noteDetails = responseData.getJSONObject("details");
            note = this.getZCRMNote(noteDetails, note);
            response.setData(note);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse deleteNote(ZCRMNote note) throws ZCRMException {
        this.requestMethod = APIConstants.RequestMethod.DELETE;
        this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName() + '/' + note.getId();
        APIResponse response = APIRequest.getInstance(this).getAPIResponse();
        return response;
    }

    public BulkAPIResponse getAllAttachmentsDetails(int page, int per_page, String modifiedSince) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName();
            this.requestQueryParams.put("page", (Object)String.valueOf(page));
            this.requestQueryParams.put("per_page", (Object)String.valueOf(per_page));
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            ArrayList<ZCRMAttachment> allAttachments = new ArrayList<ZCRMAttachment>();
            NullableJSONObject responseJSON = new NullableJSONObject(response.getResponseJSON());
            JSONArray attachmentsArray = responseJSON.optJSONArray(this.getJsonRootKey(), new JSONArray());
            for (int index = 0; index < attachmentsArray.length(); ++index) {
                allAttachments.add(this.getZCRMAttachment(attachmentsArray.getJSONObject(index)));
            }
            response.setData(allAttachments);
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse uploadAttachment(String filePath) throws ZCRMException {
        CommonUtil.validateFile(filePath);
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName();
            APIResponse response = APIRequest.getInstance(this).uploadFile(filePath);
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject details = responseData.getJSONObject("details");
            response.setData(this.getZCRMAttachment(details));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse uploadLinkAsAttachment(String attachmentUrl) throws ZCRMException {
        try {
            this.requestMethod = APIConstants.RequestMethod.POST;
            this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName();
            this.requestQueryParams.put("attachmentUrl", (Object)attachmentUrl);
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONArray responseDataArray = response.getResponseJSON().getJSONArray(this.getJsonRootKey());
            JSONObject responseData = responseDataArray.getJSONObject(0);
            JSONObject details = responseData.getJSONObject("details");
            response.setData(this.getZCRMAttachment(details));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public FileAPIResponse downloadAttachment(Long attachmentId) throws ZCRMException {
        this.requestMethod = APIConstants.RequestMethod.GET;
        this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName() + '/' + attachmentId;
        return APIRequest.getInstance(this).downloadFile();
    }

    public APIResponse deleteAttachment(Long attachmentId) throws ZCRMException {
        this.requestMethod = APIConstants.RequestMethod.DELETE;
        this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.relatedList.getApiName() + '/' + attachmentId;
        return APIRequest.getInstance(this).getAPIResponse();
    }

    private ZCRMNote getZCRMNote(JSONObject noteDetailsJSON, ZCRMNote note) throws JSONException {
        NullableJSONObject noteDetails = new NullableJSONObject(noteDetailsJSON);
        if (note == null) {
            note = ZCRMNote.getInstance(this.parentRecord, Long.parseLong(noteDetails.getString("id")));
        }
        note.setId(Long.parseLong(noteDetailsJSON.getString("id")));
        if (!noteDetails.isNull("Note_Title")) {
            note.setTitle(noteDetails.getString("Note_Title"));
        }
        if (!noteDetails.isNull("Note_Content")) {
            note.setContent(noteDetails.getString("Note_Content"));
        }
        JSONObject createdByObj = noteDetails.getJSONObject("Created_By");
        ZCRMUser createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
        note.setCreatedBy(createdBy);
        note.setCreatedTime(noteDetails.getString("Created_Time"));
        JSONObject modifiedByObj = noteDetails.getJSONObject("Modified_By");
        ZCRMUser modifiedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
        note.setModifiedBy(modifiedBy);
        note.setModifiedTime(noteDetails.getString("Modified_Time"));
        if (!noteDetails.isNull("Owner")) {
            JSONObject ownerObj = noteDetails.getJSONObject("Owner");
            ZCRMUser owner = ZCRMUser.getInstance(Long.parseLong(ownerObj.getString("id")), ownerObj.getString("name"));
            note.setOwner(owner);
        } else {
            note.setOwner(createdBy);
        }
        if (!noteDetails.isNull("$attachments")) {
            JSONArray attachmentsArray = noteDetails.getJSONArray("$attachments");
            for (int index = 0; index < attachmentsArray.length(); ++index) {
                JSONObject attachmentDetails = attachmentsArray.getJSONObject(index);
                note.addAttachment(this.getZCRMAttachment(attachmentDetails));
            }
        }
        return note;
    }

    private JSONObject getZCRMNoteAsJSON(ZCRMNote note) throws JSONException {
        JSONObject noteJSON = new JSONObject();
        if (note.getTitle() != null) {
            noteJSON.put("Note_Title", (Object)note.getTitle());
        } else {
            noteJSON.put("Note_Title", JSONObject.NULL);
        }
        noteJSON.put("Note_Content", (Object)note.getContent());
        return noteJSON;
    }

    private ZCRMAttachment getZCRMAttachment(JSONObject attachmentJson) throws JSONException {
        NullableJSONObject attachmentDetails = new NullableJSONObject(attachmentJson);
        ZCRMAttachment attachment = ZCRMAttachment.getInstance(this.parentRecord, Long.parseLong(attachmentDetails.getString("id")));
        String fileName = attachmentDetails.optString("File_Name");
        if (fileName != null) {
            attachment.setFileName(fileName);
            attachment.setFileType(fileName.substring(fileName.lastIndexOf(46) + 1, fileName.length()));
        }
        if (attachmentDetails.has("Size")) {
            attachment.setSize(Long.parseLong(attachmentDetails.getString("Size")));
        }
        if (attachmentDetails.has("Created_By")) {
            JSONObject createdByObj = attachmentDetails.getJSONObject("Created_By");
            ZCRMUser createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
            attachment.setCreatedBy(createdBy);
            attachment.setCreatedTime(attachmentDetails.getString("Created_Time"));
            if (!attachmentDetails.isNull("Owner")) {
                JSONObject ownerObj = attachmentDetails.getJSONObject("Owner");
                ZCRMUser owner = ZCRMUser.getInstance(Long.parseLong(ownerObj.getString("id")), ownerObj.getString("name"));
                attachment.setOwner(owner);
            } else {
                attachment.setOwner(createdBy);
            }
        }
        if (attachmentDetails.has("Modified_By")) {
            JSONObject modifiedByObj = attachmentDetails.getJSONObject("Modified_By");
            ZCRMUser modifiedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
            attachment.setModifiedBy(modifiedBy);
            attachment.setModifiedTime(attachmentDetails.getString("Modified_Time"));
        }
        return attachment;
    }

    public APIResponse addRelation() throws ZCRMException, JSONException {
        this.requestMethod = APIConstants.RequestMethod.PUT;
        this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.junctionRecord.getApiName() + '/' + this.junctionRecord.getId();
        JSONObject requestBodyObj = new JSONObject();
        JSONArray dataArray = new JSONArray();
        dataArray.put((Object)this.getRelationDetailsAsJSON(this.junctionRecord.getRelatedDetails()));
        requestBodyObj.put(this.getJsonRootKey(), (Object)dataArray);
        this.requestBody = requestBodyObj;
        return APIRequest.getInstance(this).getAPIResponse();
    }

    private JSONObject getRelationDetailsAsJSON(HashMap<String, Object> relatedDetails) throws JSONException {
        JSONObject relatedDetailsJSON = new JSONObject();
        for (String key : relatedDetails.keySet()) {
            Object value = relatedDetails.get(key);
            if (value == null) {
                value = JSONObject.NULL;
            } else if (value instanceof Long) {
                value = String.valueOf(relatedDetails.get(key));
            }
            relatedDetailsJSON.put(key, value);
        }
        return relatedDetailsJSON;
    }

    public APIResponse deleteRelation() throws ZCRMException {
        this.requestMethod = APIConstants.RequestMethod.DELETE;
        this.urlPath = this.parentRecord.getModuleAPIName() + '/' + this.parentRecord.getEntityId() + '/' + this.junctionRecord.getApiName() + '/' + this.junctionRecord.getId();
        return APIRequest.getInstance(this).getAPIResponse();
    }

    @Override
    public String getJsonRootKey() {
        return "data";
    }
}

