/*
 * Decompiled with CFR 0.152.
 */
package com.zoho.crm.library.api.handler;

import com.zoho.crm.library.api.APIConstants;
import com.zoho.crm.library.api.APIRequest;
import com.zoho.crm.library.api.handler.APIHandler;
import com.zoho.crm.library.api.handler.CommonAPIHandler;
import com.zoho.crm.library.api.handler.MetaDataAPIHandler;
import com.zoho.crm.library.api.response.APIResponse;
import com.zoho.crm.library.api.response.BulkAPIResponse;
import com.zoho.crm.library.common.CommonUtil;
import com.zoho.crm.library.common.NullableJSONObject;
import com.zoho.crm.library.crud.ZCRMCustomView;
import com.zoho.crm.library.crud.ZCRMField;
import com.zoho.crm.library.crud.ZCRMLayout;
import com.zoho.crm.library.crud.ZCRMModule;
import com.zoho.crm.library.crud.ZCRMModuleRelation;
import com.zoho.crm.library.crud.ZCRMPickListValue;
import com.zoho.crm.library.crud.ZCRMSection;
import com.zoho.crm.library.exception.ZCRMException;
import com.zoho.crm.library.exception.ZCRMLogger;
import com.zoho.crm.library.setup.users.ZCRMProfile;
import com.zoho.crm.library.setup.users.ZCRMUser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModuleAPIHandler
extends CommonAPIHandler
implements APIHandler {
    private ZCRMModule module;
    private static String jsonRootKey;

    private ModuleAPIHandler(ZCRMModule moduleObj) {
        this.module = moduleObj;
    }

    public static ModuleAPIHandler getInstance(ZCRMModule moduleObj) {
        return new ModuleAPIHandler(moduleObj);
    }

    public void getModuleDetails() throws ZCRMException {
        this.module = (ZCRMModule)MetaDataAPIHandler.getInstance().getModule(this.module.getApiName()).getData();
    }

    public APIResponse getLayoutDetails(Long layoutId) throws ZCRMException {
        try {
            jsonRootKey = "layouts";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/layouts/" + layoutId;
            this.requestQueryParams.put("module", (Object)this.module.getApiName());
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            JSONArray layoutsArray = responseJSON.getJSONArray(jsonRootKey);
            response.setData(this.getZCRMLayout(layoutsArray.getJSONObject(0)));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getAllLayouts(String modifiedSince) throws ZCRMException {
        try {
            jsonRootKey = "layouts";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/layouts";
            this.requestQueryParams.put("module", (Object)this.module.getApiName());
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            response.setData(this.getAllLayouts(response.getResponseJSON()));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse getField(Long fieldId) throws ZCRMException {
        try {
            jsonRootKey = "fields";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/fields/" + fieldId;
            this.requestQueryParams.put("module", (Object)this.module.getApiName());
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            JSONArray fieldArray = responseJSON.getJSONArray(jsonRootKey);
            response.setData(this.getZCRMField(fieldArray.getJSONObject(0)));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getAllFields(String modifiedSince) throws ZCRMException {
        try {
            jsonRootKey = "fields";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/fields";
            this.requestQueryParams.put("module", (Object)this.module.getApiName());
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            response.setData(this.getAllFields(response.getResponseJSON()));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getAllCustomViews(String modifiedSince) throws ZCRMException {
        try {
            jsonRootKey = "custom_views";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/custom_views";
            this.requestQueryParams.put("module", (Object)this.module.getApiName());
            this.requestHeaders.put("If-Modified-Since", (Object)modifiedSince);
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            response.setData(this.getAllCustomViews(response.getResponseJSON()));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse getCustomView(long cvID) throws ZCRMException {
        try {
            jsonRootKey = "custom_views";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/custom_views/" + cvID;
            this.requestQueryParams.put("module", (Object)this.module.getApiName());
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            JSONArray customViewArray = responseJSON.getJSONArray(jsonRootKey);
            response.setData(this.getZCRMCustomView(customViewArray.getJSONObject(0)));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public APIResponse getRelatedList(Long relatedListId) throws ZCRMException {
        try {
            jsonRootKey = "related_lists";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/related_lists/" + relatedListId;
            this.requestQueryParams.put("module", (Object)this.module.getApiName());
            APIResponse response = APIRequest.getInstance(this).getAPIResponse();
            JSONObject responseJSON = response.getResponseJSON();
            response.setData(this.getAllRelatedLists(responseJSON).get(0));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public BulkAPIResponse getAllRelatedLists() throws ZCRMException {
        try {
            jsonRootKey = "related_lists";
            this.requestMethod = APIConstants.RequestMethod.GET;
            this.urlPath = "settings/related_lists";
            this.requestQueryParams.put("module", (Object)this.module.getApiName());
            BulkAPIResponse response = APIRequest.getInstance(this).getBulkAPIResponse();
            response.setData(this.getAllRelatedLists(response.getResponseJSON()));
            return response;
        }
        catch (JSONException je) {
            ZCRMLogger.logError(je);
            throw new ZCRMException("ZCRM_INTERNAL_ERROR", je);
        }
    }

    public List<ZCRMLayout> getAllLayouts(JSONObject responseJSON) throws JSONException {
        ArrayList<ZCRMLayout> allLayouts = new ArrayList<ZCRMLayout>();
        JSONArray layoutsArray = responseJSON.getJSONArray(jsonRootKey);
        for (int index = 0; index < layoutsArray.length(); ++index) {
            allLayouts.add(this.getZCRMLayout(layoutsArray.getJSONObject(index)));
        }
        return allLayouts;
    }

    public List<ZCRMSection> getAllSectionsOfLayout(JSONObject layoutDetails) throws JSONException {
        ArrayList<ZCRMSection> sections = new ArrayList<ZCRMSection>();
        JSONArray sectionsArray = layoutDetails.getJSONArray("sections");
        for (int index = 0; index < sectionsArray.length(); ++index) {
            sections.add(this.getZCRMSection(sectionsArray.getJSONObject(index)));
        }
        return sections;
    }

    public List<ZCRMField> getAllFields(JSONObject sectionDetails) throws JSONException {
        ArrayList<ZCRMField> fields = new ArrayList<ZCRMField>();
        JSONArray fieldsArray = sectionDetails.getJSONArray("fields");
        for (int index = 0; index < fieldsArray.length(); ++index) {
            fields.add(this.getZCRMField(fieldsArray.getJSONObject(index)));
        }
        return fields;
    }

    public List<ZCRMCustomView> getAllCustomViews(JSONObject responseJSON) throws JSONException {
        ArrayList<ZCRMCustomView> allCustomViews = new ArrayList<ZCRMCustomView>();
        JSONArray customViewsArray = responseJSON.getJSONArray(jsonRootKey);
        for (int index = 0; index < customViewsArray.length(); ++index) {
            allCustomViews.add(this.getZCRMCustomView(customViewsArray.getJSONObject(index)));
        }
        return allCustomViews;
    }

    public List<ZCRMModuleRelation> getAllRelatedLists(JSONObject responseJSON) throws JSONException {
        ArrayList<ZCRMModuleRelation> relatedLists = new ArrayList<ZCRMModuleRelation>();
        JSONArray relatedListsArray = responseJSON.getJSONArray(jsonRootKey);
        for (int index = 0; index < relatedListsArray.length(); ++index) {
            relatedLists.add(this.getZCRMModuleRelation(relatedListsArray.getJSONObject(index)));
        }
        return relatedLists;
    }

    public ZCRMLayout getZCRMLayout(JSONObject layoutDetails) throws JSONException {
        ZCRMLayout layout = ZCRMLayout.getInstance(Long.parseLong(layoutDetails.getString("id")));
        layout.setName(layoutDetails.getString("name"));
        layout.setVisible(layoutDetails.getBoolean("visible"));
        layout.setStatus(layoutDetails.getInt("status"));
        if (!layoutDetails.isNull("created_by")) {
            JSONObject createdByObj = layoutDetails.getJSONObject("created_by");
            ZCRMUser createdBy = ZCRMUser.getInstance(Long.parseLong(createdByObj.getString("id")), createdByObj.getString("name"));
            layout.setCreatedBy(createdBy);
            layout.setCreatedTime(layoutDetails.getString("created_time"));
        }
        if (!layoutDetails.isNull("modified_by")) {
            JSONObject modifiedByObj = layoutDetails.getJSONObject("modified_by");
            ZCRMUser modifiedBy = ZCRMUser.getInstance(Long.parseLong(modifiedByObj.getString("id")), modifiedByObj.getString("name"));
            layout.setModifiedBy(modifiedBy);
            layout.setModifiedTime(layoutDetails.getString("modified_time"));
        }
        JSONArray accessibleProfilesArray = layoutDetails.getJSONArray("profiles");
        for (int index = 0; index < accessibleProfilesArray.length(); ++index) {
            JSONObject profileObj = accessibleProfilesArray.getJSONObject(index);
            ZCRMProfile profile = ZCRMProfile.getInstance(Long.parseLong(profileObj.getString("id")), profileObj.getString("name"));
            layout.addAccessibleProfile(profile);
        }
        layout.setSections(this.getAllSectionsOfLayout(layoutDetails));
        return layout;
    }

    private ZCRMSection getZCRMSection(JSONObject sectionDetails) throws JSONException {
        ZCRMSection section = ZCRMSection.getInstance(sectionDetails.getString("name"));
        section.setColumnCount(sectionDetails.getInt("column_count"));
        section.setDisplayName(sectionDetails.getString("display_label"));
        section.setSequence(sectionDetails.getInt("sequence_number"));
        if (sectionDetails.has("isSubformSection")) {
            section.setSubformSection(sectionDetails.getBoolean("isSubformSection"));
        }
        section.addFields(this.getAllFields(sectionDetails));
        return section;
    }

    private ZCRMField getZCRMField(JSONObject fieldJSON) throws JSONException {
        JSONObject subLayouts;
        NullableJSONObject fieldDetails = new NullableJSONObject(fieldJSON);
        ZCRMField field = ZCRMField.getInstance(fieldDetails.getString("api_name"));
        field.setDefaultValue(fieldDetails.opt("default_value"));
        field.setMandatory(fieldDetails.getBoolean("required"));
        field.setId(Long.parseLong(fieldDetails.getString("id")));
        field.setCustomField(fieldDetails.getBoolean("custom_field"));
        field.setDataType(fieldDetails.getString("data_type"));
        field.setDisplayName(fieldDetails.getString("field_label"));
        field.setMaxLength(fieldDetails.optInt("length"));
        field.setPrecision(fieldDetails.optInt("decimal_place"));
        field.setReadOnly(fieldDetails.getBoolean("read_only"));
        field.setVisible(fieldDetails.getBoolean("visible"));
        field.setSequenceNo(fieldDetails.optInt("sequence_number"));
        field.setToolTip(fieldDetails.optString("tooltip"));
        field.setWebhook(fieldDetails.getBoolean("webhook"));
        field.setCreatedSource(fieldDetails.getString("created_source"));
        NullableJSONObject formulaDetails = new NullableJSONObject(fieldDetails.getJSONObject("formula"));
        field.setFormulaReturnType(formulaDetails.optString("return_type"));
        NullableJSONObject currencyDetails = new NullableJSONObject(fieldDetails.getJSONObject("currency"));
        field.setPrecision(currencyDetails.optInt("precision"));
        if (!currencyDetails.isNull("rounding_option")) {
            field.setRoundingOption(CommonUtil.CurrencyRoundingOption.valueOf(currencyDetails.optString("rounding_option")));
        }
        if ((subLayouts = fieldDetails.getJSONObject("view_type")) != null) {
            ArrayList<String> layoutsPresent = new ArrayList<String>();
            if (subLayouts.getBoolean("create")) {
                layoutsPresent.add("CREATE");
            }
            if (subLayouts.getBoolean("view")) {
                layoutsPresent.add("VIEW");
            }
            if (subLayouts.getBoolean("quick_create")) {
                layoutsPresent.add("QUICK_CREATE");
            }
            field.setSubLayoutsPresent(layoutsPresent);
        }
        JSONArray pickList = fieldDetails.getJSONArray("pick_list_values");
        for (int index = 0; index < pickList.length(); ++index) {
            NullableJSONObject pickListObj = new NullableJSONObject(pickList.getJSONObject(index));
            ZCRMPickListValue pickListValue = ZCRMPickListValue.getInstance();
            pickListValue.setDisplayName(pickListObj.getString("display_value"));
            pickListValue.setActualName(pickListObj.getString("actual_value"));
            pickListValue.setSequenceNumber(pickListObj.optInt("sequence_number"));
            pickListValue.setMaps(pickListObj.optJSONArray("maps", new JSONArray()));
            field.addPickListValue(pickListValue);
        }
        JSONObject lookup = fieldDetails.getJSONObject("lookup");
        Iterator lookupItr = lookup.keys();
        while (lookupItr.hasNext()) {
            String fieldAPIName = (String)lookupItr.next();
            field.setLookupDetails(fieldAPIName, lookup.get(fieldAPIName));
        }
        NullableJSONObject multilookup = new NullableJSONObject(fieldDetails.getJSONObject("multiselectlookup"));
        Iterator<String> multilookupItr = multilookup.keys();
        while (multilookupItr.hasNext()) {
            String fieldAPIName = multilookupItr.next();
            field.setMultiselectLookup(fieldAPIName, multilookup.get(fieldAPIName));
        }
        if (fieldDetails.has("subformtabid")) {
            field.setSubformTabId(fieldDetails.getLong("subformtabid"));
        }
        if (fieldDetails.has("subform")) {
            NullableJSONObject subformDetails = new NullableJSONObject(fieldDetails.getJSONObject("subform"));
            Iterator<String> subformDetailsItr = subformDetails.keys();
            while (subformDetailsItr.hasNext()) {
                String fieldAPIName = subformDetailsItr.next();
                field.setSubformDetails(fieldAPIName, subformDetails.opt(fieldAPIName));
            }
        }
        if (fieldDetails.has("private") && !fieldDetails.isNull("private")) {
            JSONObject fieldPrivateDetails = fieldDetails.getJSONObject("private");
            field.setExportable(fieldPrivateDetails.getBoolean("export"));
            field.setRestricted(fieldPrivateDetails.getBoolean("restricted"));
            field.setType(CommonUtil.RestrictedType.valueOf(fieldPrivateDetails.getString("type")));
        }
        return field;
    }

    public ZCRMCustomView getZCRMCustomView(JSONObject customViewJson) throws JSONException {
        NullableJSONObject customViewDetails = new NullableJSONObject(customViewJson);
        ZCRMCustomView customView = ZCRMCustomView.getInstance(this.module.getApiName(), Long.parseLong(customViewDetails.getString("id")));
        customView.setDisplayName(customViewDetails.getString("display_value"));
        customView.setDefault(customViewDetails.getBoolean("default"));
        customView.setSystemName(customViewDetails.optString("system_name"));
        customView.setCategory(customViewDetails.getString("category"));
        if (!customViewDetails.isNull("favorite")) {
            customView.setFavorite(customViewDetails.getInt("favorite"));
        }
        customView.setName(customViewDetails.getString("name"));
        customView.setSortBy(customViewDetails.optString("sort_by"));
        if (!customViewDetails.isNull("sort_order")) {
            customView.setSortOrder(CommonUtil.SortOrder.valueOf(customViewDetails.getString("sort_order")));
        }
        ArrayList<String> fields = new ArrayList<String>();
        if (customViewDetails.has("fields")) {
            JSONArray fieldsArray = customViewDetails.getJSONArray("fields");
            for (int index = 0; index < fieldsArray.length(); ++index) {
                fields.add(fieldsArray.getString(index));
            }
        }
        customView.setFields(fields);
        return customView;
    }

    public ZCRMModuleRelation getZCRMModuleRelation(JSONObject relatedListDetails) throws JSONException {
        ZCRMModuleRelation moduleRelation = ZCRMModuleRelation.getInstance(this.module.getApiName(), Long.parseLong(relatedListDetails.getString("id")));
        moduleRelation.setApiName(relatedListDetails.getString("api_name"));
        moduleRelation.setLabel(relatedListDetails.getString("display_label"));
        moduleRelation.setModule(relatedListDetails.getString("module"));
        moduleRelation.setName(relatedListDetails.getString("name"));
        moduleRelation.setType(relatedListDetails.getString("type"));
        return moduleRelation;
    }

    @Override
    public String getJsonRootKey() {
        return jsonRootKey;
    }
}

